#include "editableattribute.h"

EditableAttribute::EditableAttribute(std::string name,
				     std::string description) {
    this->name = name;
    this->description = description;
}

void EditableAttribute::notifyChange() {
    for (unsigned i=0;i<observers.size();i++) {
        observers[i]->attributeChanged(this);
    }
}

void EditableAttribute::addObserver(Observer *obs) {
    observers.push_back(obs);
}

void EditableAttribute::removeObserver(Observer *obs) {
    std::vector< Observer* >::iterator iter;
    for (iter=observers.begin(); iter!=observers.end();) {
	if (*iter == obs) {
            observers.erase(iter);
	} else {
	    iter++;
	}
    }
}
