#ifndef __ED_VEC3_H__
#define __ED_VEC3_H__

#include <osg/Vec3>
#include <editable/editableattribute.h>

/** @class EdVec3
 * @brief Editable attribute for osg::Vec3
 */
class EdVec3: public EditableAttribute {
public:
    EdVec3(std::string name, std::string description);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "Vec3"; }

    inline osg::Vec3 get() const { return value; }
    inline osg::Vec3 getOriginal() const { return original; }
    void set(const osg::Vec3 &_value);

    inline void setInitial(const osg::Vec3 &_value) { value=_value;original=_value; }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }

    virtual std::string toString() const;
private:
    osg::Vec3 value;
    osg::Vec3 original;
};

#endif
