#include <stdio.h>
#include "edvec3.h"

EdVec3::EdVec3(std::string name,
	       std::string description):
    EditableAttribute(name, description),
    value(0,0,0),
    original(0,0,0)
{

}

void EdVec3::set(const osg::Vec3 &_value) {
    value=_value;
    notifyChange();
}

std::string EdVec3::toString() const {
    char buffer[9];
    sprintf(buffer,"%f, %f, %f",
	    int(value[0]*255),
	    int(value[1]*255),
	    int(value[2]*255),
	    int(value[3]*255));
    return std::string(buffer);
}
