#ifndef __ED_STRING_H__
#define __ED_STRING_H__

#include <editable/editableattribute.h>

/** @class EdString
 * @brief Editable attribute for strings
 */
class EdString: public EditableAttribute {
public:
    EdString(std::string name, std::string description);
    EdString(std::string name, std::string description, std::string _value);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "string"; }

    inline std::string get() const { return value; }
    inline std::string getOriginal() const { return original; }
    void set(std::string _value);

    inline void setInitial(std::string _value) { value=_value;original=_value; }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }

    inline virtual std::string toString() const { return value; }
private:
    std::string value;
    std::string original;
};

#endif
