#include <iostream>
#include <editable/editableentity.h>
#include <stdio.h>
#include "edreference.h"

EdReference::EdReference(std::string name,
			 std::string description):
    EditableAttribute(name, description)
{

}

void EdReference::set(std::string the_class) {
    if (map.find(the_class) != map.end()) {
	value=map[the_class]->clone();
        value->genObject();
	//FIXME: value=_value;
	notifyChange();
    } else {
	std::cerr << "FATAL ERROR: EdReference::set: Unknow class '" << the_class << "'" << std::endl;
    }
}

void EdReference::setInitial(EditableEntity *entity) {
    original=entity;
    value=entity;
}

void EdReference::setNull() {
    value=0;
}

std::string EdReference::toString() const {
    if (value.valid()) {
	return value->getName();
    } else {
        return "NULL";
    }
}

void EdReference::addClass(std::string name, EditableEntity *prototype) {
    map[name]=prototype;
}

std::vector<std::string> EdReference::getClasses() {
    std::map<std::string, osg::ref_ptr<EditableEntity> >::iterator iter;
    std::vector<std::string> result;
    for (iter=map.begin(); iter != map.end(); iter++) {
        result.push_back(iter->first);
    }
    return result;
}
