#ifndef __ED_MATRIX_H__
#define __ED_MATRIX_H__

#include <osg/Matrix>
#include <editable/editableattribute.h>

/** @class EdMatrix
 * @brief Editable attribute for osg::Matrix a 4x4 Matrix encapsulating 3D
 * transformations.
 */
class EdMatrix: public EditableAttribute {
public:
    EdMatrix(std::string name, std::string description);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "Matrix"; }

    inline osg::Matrix get() const { return value; }
    inline osg::Matrix getOriginal() const { return original; }
    void set(const osg::Matrix &_value);

    inline void setInitial(const osg::Matrix &_value) { value=_value;original=_value; }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }

    virtual std::string toString() const;
private:
    osg::Matrix value;
    osg::Matrix original;
};

#endif
