#include <stdio.h>
#include "edmatrix.h"

EdMatrix::EdMatrix(std::string name,
	       std::string description):
    EditableAttribute(name, description),
    value(osg::Matrix::identity()),
    original(osg::Matrix::identity())
{

}

void EdMatrix::set(const osg::Matrix &_value) {
    value=_value;
    notifyChange();
}

std::string EdMatrix::toString() const {
    /// It's better not to represent the whole matrix for displaying into lists...
    return "[...]";
}
