#ifndef __ED_LIST_H__
#define __ED_LIST_H__

#include <iostream>
#include <editable/editableattribute.h>
#include <vector>

/** @class EdList
 * @brief Editable attribute for lists
 * Each entry of the list is again a list of attributes.
 * This kind of complex attribute was thought for things like editting the
 * switched state for each osg::Switch child, or the min/max range for each
 * osg::Lod child and so on.
 * Each entry is in fact very similar to an EditableEntity, but the entry
 * doesn't have entity, it's only a list of attributes binded to some
 * index, without even a name.
 */
class EdList: public EditableAttribute {
public:
    typedef std::pair< std::string, EditableAttributeList > ListItem;
    typedef std::vector< ListItem > List;
public:
    EdList(std::string name, std::string description);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "list"; }

    /** Get access to the name of one of the attributes */
    inline const std::string getItemName(unsigned i) { return values[i].first; }

    /** Get access to one of the attributes */
    inline const EditableAttributeList& get(unsigned i) { return values[i].second; }

    inline unsigned length() { return values.size(); }

    /** Take care of add all the attributes of the same type, or this method
     * will fail */
    void add(std::string name, EditableAttributeList entry) { values.push_back(ListItem(name, entry)); }

    /** Checks if the attribute has changed */
    virtual bool hasChanged() const;

    inline virtual std::string toString() const {
	std::cerr << "FATAL ERROR (BUG)!: Asking string value of a List!!!" << std::endl;
	throw -1;
    }
private:
    List values;
};

#endif
