#ifndef __ED_INT_H__
#define __ED_INT_H__

#include <editable/editableattribute.h>

/** @class EdInt
 * @brief Editable attribute for integers
 */
class EdInt: public EditableAttribute {
public:
    EdInt(std::string name, std::string description, int _value, int _min, int _max);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "int"; }

    inline int get() const { return value; }
    inline int getOriginal() const { return original; }
    void set(int _value);

    inline int getMin() const { return min; }
    inline int getMax() const { return max; }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }

    virtual std::string toString() const;
private:
    int value;
    int original;
    int min;
    int max;
};

#endif
