#ifndef __ED_FLOAT_H__
#define __ED_FLOAT_H__

#include <editable/editableattribute.h>

/** @class EdFloat
 * @brief Editable attribute for floats
 */
class EdFloat: public EditableAttribute {
public:
    EdFloat(std::string name, std::string description, float _value, float _min, float _max);
    EdFloat(std::string name, std::string description);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "float"; }

    inline float get() const { return value; }
    inline float getOriginal() const { return original; }
    void set(float _value);

    inline float getMin() const { return min; }
    inline float getMax() const { return max; }

    inline void setInitial(float _value) { value=_value;original=_value; }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }

    virtual std::string toString() const;
private:
    float value;
    float original;
    float min;
    float max;
};

#endif
