#include <stdio.h>
#include "edfloat.h"
#include <glib.h> // G_MINFLOAT, G_MAXFLOAT

EdFloat::EdFloat(std::string name,
		 std::string description,
		 float _value, float _min, float _max):
    EditableAttribute(name, description),
    value(_value),
    original(_value),
    min(_min),
    max(_max)
{

}

EdFloat::EdFloat(std::string name,
		 std::string description):
    EditableAttribute(name, description),
    value(0.0f),
    original(0.0f),
    min(0.0f),
    max(G_MAXFLOAT)
{

}

void EdFloat::set(float _value) {
    value=_value;
    notifyChange();
}


std::string EdFloat::toString() const {
    char buffer[256];
    sprintf(buffer,"%f",value);
    return std::string(buffer);
}
