#include <iostream>
#include "edenum.h"

EdEnum::EdEnum(std::string name,
	       std::string description):
    EditableAttribute(name, description),
    value_index(-1)
{

}

void EdEnum::set(int _value_index) {
    value_index=_value_index;
    notifyChange();
}

void EdEnum::addOption(std::string name, int value) {
    options.push_back(EnumOption(name,value));
}

int EdEnum::getValue() const {
    if (value_index >= 0 && value_index < options.size()) {
	return options[value_index].second;
    } else {
	std::cerr << "EdEnum::getValue(): ERROR! Value index ("<< value_index << ") out of bounds!" << std::endl;
        throw -1;
    }
}

std::string EdEnum::getValueName() const {
    if (value_index >= 0 && value_index < options.size()) {
	return options[value_index].first;
    } else {
	std::cerr << "EdEnum::getValue(): ERROR! Value index ("<< value_index << ") out of bounds!" << std::endl;
        throw -1;
    }
}

std::string EdEnum::getOriginalValueName() const {
    if (original_index >= 0 && original_index < options.size()) {
	return options[original_index].first;
    } else {
	std::cerr << "EdEnum::getValue(): ERROR! Original index ("<< original_index << ") out of bounds!" << std::endl;
        throw -1;
    }
}

void EdEnum::setInitial(int _value) {
    OptionList::const_iterator iter;
    unsigned index=0;
    value_index=-1;
    for (iter=options.begin(); iter!=options.end(); iter++) {
	if (iter->second == _value) {
	    value_index=index;
            original_index=index;
            break;
	} else {
            index++;
	}
    }
    if (value_index < 0) {
	std::cerr << "EdEnum::setInitial: There is not an option for value '" << _value << "' in the enumeration '" << getName() << "'. Assuming 0!" << std::endl;
        value_index=0;
    }
}

std::string EdEnum::getOption(unsigned i) const {
    if (i < options.size()) {
        return options[i].first;
    } else {
	std::cerr << "EdEnum::getOption: ERROR! index " << i << " out of bounds" << std::endl;
        throw -1;
    }
}
