#ifndef __ED_COLOUR_H__
#define __ED_COLOUR_H__

#include <osg/Vec4>
#include <editable/editableattribute.h>

/** @class EdColour
 * @brief Editable attribute for osg::Vec4
 */
class EdColour: public EditableAttribute {
public:
    EdColour(std::string name, std::string description);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "Colour"; }

    inline osg::Vec4 get() const { return value; }
    inline osg::Vec4 getOriginal() const { return original; }
    void set(const osg::Vec4 &_value);

    inline void setInitial(const osg::Vec4 &_value) { value=_value;original=_value; }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }
    virtual std::string toString() const;
private:
    osg::Vec4 value;
    osg::Vec4 original;
};

#endif
