#include <stdio.h>
#include "edcolour.h"

EdColour::EdColour(std::string name,
		   std::string description):
    EditableAttribute(name, description),
    value(0,0,0,0),
    original(0,0,0,0)
{

}

void EdColour::set(const osg::Vec4 &_value) {
    value=_value;
    notifyChange();
}

std::string EdColour::toString() const {
    char buffer[9];
    sprintf(buffer,"%02x%02x%02x%02x",
	    int(value[0]*255),
	    int(value[1]*255),
	    int(value[2]*255),
	    int(value[3]*255));
    return std::string(buffer);
}
