#ifndef __ED_BOOL_H__
#define __ED_BOOL_H__

#include <editable/editableattribute.h>

/** @class EdBool
 * @brief Editable attribute for bool's
 */
class EdBool: public EditableAttribute {
public:
    EdBool(std::string name, std::string description, bool _value);

    /** Returns the type of this attribute */
    virtual std::string getType() { return "bool"; }

    inline bool get() const { return value; }
    inline bool getOriginal() const { return original; }
    void set(bool _value);
    inline void toggle() { set(!value); }

    /** Checks if the attribute has changed */
    inline virtual bool hasChanged() const { return original != value; }

    inline virtual std::string toString() const { return value?"true":"false"; }
private:
    bool value;
    bool original;
};

#endif
