#ifndef __META_COMMAND_H__
#define __META_COMMAND_H__

#include "command.h"

/** @class MetaCommand
 * It's a bunch of commands executed all as one single command (atomic).
 * The advantage is that it makes a single entry on the history and can be
 * undo and redo with a single order from the user.
 */
class MetaCommand: public Command {
    typedef std::vector<osg::ref_ptr<Command> > CommandList;
    CommandList commands;
public:
    MetaCommand();
    void addCommand(Command *c); ///< Adds a new command to this meta-command
    virtual ~MetaCommand() {}
    virtual void realExecute();
    virtual void undo();
};


#endif
