#include "metacommand.h"

MetaCommand::MetaCommand() {}

void MetaCommand::addCommand(Command *c) {
    commands.push_back(c);
}

void MetaCommand::realExecute() {
    CommandList::iterator iter;
    for (iter=commands.begin(); iter != commands.end(); iter++) {
	osg::ref_ptr<Command> c = *iter;
        c->execute(false);
    }
}

void MetaCommand::undo() {
    CommandList::reverse_iterator iter;
    for (iter=commands.rend(); iter != commands.rbegin(); iter++) {
	osg::ref_ptr<Command> c = *iter;
	c->undo();
    }
}
