#ifndef __ComTexture_H__
#define __ComTexture_H__

#include "command.h"
#include <osg/Texture2D>
#include <string>

class ComTexture: public Command {
public:
    ComTexture(osg::Texture2D *node,
	       std::string image_file,
	       osg::Texture::WrapMode wrap_s,
	       osg::Texture::WrapMode wrap_t,
	       osg::Texture::WrapMode wrap_r,
	       osg::Vec4 border_color,
	       osg::Texture::FilterMode min_filter,
	       osg::Texture::FilterMode mag_filter);
    virtual ~ComTexture() {}
    virtual void realExecute();
    virtual void undo();
private:
    osg::ref_ptr< osg::Texture2D > affected;
    //Attributes
    osg::Image *image_old;
    osg::Image *image_new;
    osg::Texture::WrapMode wrap_s_old;
    osg::Texture::WrapMode wrap_s_new;
    osg::Texture::WrapMode wrap_t_old;
    osg::Texture::WrapMode wrap_t_new;
    osg::Texture::WrapMode wrap_r_old;
    osg::Texture::WrapMode wrap_r_new;
    osg::Vec4 border_color_old;
    osg::Vec4 border_color_new;
    osg::Texture::FilterMode min_filter_old;
    osg::Texture::FilterMode min_filter_new;
    osg::Texture::FilterMode mag_filter_old;
    osg::Texture::FilterMode mag_filter_new;

};
#endif //__EdTexture_H__
