#include <osgDB/ReadFile>
#include "comtexture.h"

ComTexture::ComTexture(osg::Texture2D *node,
		       std::string image_file,
		       osg::Texture::WrapMode wrap_s,
		       osg::Texture::WrapMode wrap_t,
		       osg::Texture::WrapMode wrap_r,
		       osg::Vec4 border_color,
		       osg::Texture::FilterMode min_filter,
		       osg::Texture::FilterMode mag_filter) {
    this->affected=node;

    this->image_old = node->getImage();
    this->wrap_s_old = (osg::Texture::WrapMode)node->getWrap(osg::Texture::WRAP_S);
    this->wrap_t_old = (osg::Texture::WrapMode)node->getWrap(osg::Texture::WRAP_T);
    this->wrap_r_old = (osg::Texture::WrapMode)node->getWrap(osg::Texture::WRAP_R);
    this->border_color_old = node->getBorderColor();
    this->min_filter_old = (osg::Texture::FilterMode)node->getFilter(osg::Texture::MIN_FILTER);
    this->mag_filter_old = (osg::Texture::FilterMode)node->getFilter(osg::Texture::MAG_FILTER);
    this->image_new = osgDB::readImageFile(image_file);
    this->wrap_s_new = wrap_s;
    this->wrap_t_new = wrap_t;
    this->wrap_r_new = wrap_r;
    this->border_color_new = border_color;
    this->min_filter_new = min_filter;
    this->mag_filter_new = mag_filter;

}

void ComTexture::realExecute() {

    affected->setImage(image_new);
    affected->setWrap(osg::Texture::WRAP_S,wrap_s_new);
    affected->setWrap(osg::Texture::WRAP_T,wrap_t_new);
    affected->setWrap(osg::Texture::WRAP_R,wrap_r_new);
    affected->setBorderColor(border_color_new);
    affected->setFilter(osg::Texture::MIN_FILTER,min_filter_new);
    affected->setFilter(osg::Texture::MAG_FILTER,mag_filter_new);
}

void ComTexture::undo() {

    affected->setImage(image_old);
    affected->setWrap(osg::Texture::WRAP_S,wrap_s_old);
    affected->setWrap(osg::Texture::WRAP_T,wrap_t_old);
    affected->setWrap(osg::Texture::WRAP_R,wrap_r_old);
    affected->setBorderColor(border_color_old);
    affected->setFilter(osg::Texture::MIN_FILTER,min_filter_old);
    affected->setFilter(osg::Texture::MAG_FILTER,mag_filter_old);
}

