#ifndef __ComStateSet_H__
#define __ComStateSet_H__

#include "command.h"
#include <osg/StateSet>

class ComStateSet: public Command {
public:
    ComStateSet(osg::StateSet *node,
   osg::StateSet::ModeList modes,
   osg::StateSet::TextureModeList texture_modes,
   int rendering_hint);
    virtual ~ComStateSet() {}
    virtual void realExecute();
    virtual void undo();
private:
    osg::ref_ptr< osg::StateSet > affected;
    //Attributes
    osg::StateSet::ModeList modes_old;
    osg::StateSet::ModeList modes_new;    
    osg::StateSet::TextureModeList texture_modes_old;
    osg::StateSet::TextureModeList texture_modes_new;    
    int rendering_hint_old;
    int rendering_hint_new;    
    
};
#endif //__EdStateSet_H__
