#include "comstateset.h"

ComStateSet::ComStateSet(osg::StateSet *node,
			 osg::StateSet::ModeList modes,
			 osg::StateSet::TextureModeList texture_modes,
			 int rendering_hint) {
    this->affected=node;

    this->modes_old = node->getModeList();
    this->texture_modes_old = node->getTextureModeList();
    this->rendering_hint_old = (int)node->getRenderingHint();
    this->modes_new = modes;
    this->texture_modes_new = texture_modes;
    this->rendering_hint_new = rendering_hint;

}

void ComStateSet::realExecute() {
    osg::StateSet::ModeList::iterator miter;
    for (miter=modes_new.begin();miter != modes_new.end();miter++) {
        affected->setMode(miter->first, miter->second);
    }
    for (unsigned unit = 0; unit < texture_modes_new.size(); unit++) {
	for (miter=texture_modes_new[unit].begin();miter != texture_modes_new[unit].end();miter++) {
            affected->setTextureMode(unit,miter->first, miter->second);
	}
    }

    affected->setRenderingHint(rendering_hint_new);
}

void ComStateSet::undo() {
    osg::StateSet::ModeList::iterator miter;
    for (miter=modes_old.begin();miter != modes_old.end();miter++) {
        affected->setMode(miter->first, miter->second);
    }
    for (unsigned unit = 0; unit < texture_modes_old.size(); unit++) {
	for (miter=texture_modes_old[unit].begin();miter != texture_modes_old[unit].end();miter++) {
            affected->setTextureMode(unit,miter->first, miter->second);
	}
    }

    affected->setRenderingHint(rendering_hint_old);
}

