#ifndef __COM_SEQUENCE_H__
#define __COM_SEQUENCE_H__

#include "command.h"
#include <osg/Sequence>
#include <vector>

class ComSequence: public Command {
    osg::ref_ptr<osg::Sequence> affected;

    osg::Sequence::LoopMode loop_mode_old;
    int loop_begin_old;
    int loop_end_old;
    float speed_old;
    int repetitions_old;
    std::vector<float> times_old;

    osg::Sequence::LoopMode loop_mode_new;
    int loop_begin_new;
    int loop_end_new;
    float speed_new;
    int repetitions_new;
    std::vector<float> times_new;

public:
    ComSequence(osg::Sequence *node,
		osg::Sequence::LoopMode loop_mode,
		int loop_begin,
		int loop_end,
		float speed,
		int repetitions,
		std::vector<float> times);
    virtual ~ComSequence() {}
    virtual void realExecute();
    virtual void undo();
};

#endif
