#include "comsequence.h"


ComSequence::ComSequence(osg::Sequence *node,
			 osg::Sequence::LoopMode loop_mode,
			 int loop_begin,
			 int loop_end,
			 float speed,
			 int repetitions,
			 std::vector<float> times) {
    this->affected=node;

    node->getInterval(loop_mode_old, loop_begin_old, loop_end_old);
    node->getDuration(speed_old, repetitions_old);

    for (unsigned i=0;i<node->getNumChildren();i++) {
        times_old.push_back(node->getTime(i));
    }

    this->loop_mode_new=loop_mode;
    this->loop_begin_new=loop_begin;
    this->loop_end_new=loop_end;
    this->speed_new=speed;
    this->repetitions_new=repetitions;
    this->times_new=times;
}

void ComSequence::realExecute() {
    affected->setInterval(loop_mode_new, loop_begin_new, loop_end_new);
    affected->setDuration(speed_new, repetitions_new);
    for (unsigned i=0;i<affected->getNumChildren();i++) {
        affected->setTime(i, times_new[i]);
    }
}

void ComSequence::undo() {
    affected->setInterval(loop_mode_old, loop_begin_old, loop_end_old);
    affected->setDuration(speed_old, repetitions_old);
    for (unsigned i=0;i<affected->getNumChildren();i++) {
        affected->setTime(i, times_old[i]);
    }
}
