#include "comscale.h"
#include <editor.h>

ComScale::ComScale(osg::MatrixTransform *node, float scale) {
    affected=node;
    original=affected->getMatrix();
    osg::Matrix m;
    m.makeScale(scale,scale,scale);
    target=original*m;
}

void ComScale::realExecute() {
    affected->setMatrix(target);
}

void ComScale::undo() {
    affected->setMatrix(original);
}
