#include "comrotate.h"
#include <editor.h>

ComRotate::ComRotate(osg::MatrixTransform *node, osg::Vec3 quat_vec, float angle) {
    affected=node;
    original=affected->getMatrix();
    osg::Matrix m;
    m.makeRotate(angle,quat_vec);
    target=original*m;
}

void ComRotate::realExecute() {
    affected->setMatrix(target);
}

void ComRotate::undo() {
    affected->setMatrix(original);
}
