#include "comrename.h"

osg::ref_ptr<osg::Node> node;
char *original;
char *target;

ComRename::ComRename(osg::Node *node, char *newname, SceneGraph *sg) {
    this->node=node;
    this->target=strdup(newname);
    this->original=strdup(node->getName().c_str());
    this->sceneGraph=sg;
}

ComRename::~ComRename() {
    free(target);
    free(original);
}

void ComRename::realExecute() {
    sceneGraph->renameNode(node.get(),target);
}

void ComRename::undo() {
    sceneGraph->renameNode(node.get(),original);
}
