#ifndef __ComMaterial_H__
#define __ComMaterial_H__

#include "command.h"
#include <osg/Material>

class ComMaterial: public Command {
public:
    ComMaterial(osg::Material *node,
		osg::Vec4 ambient_front,
		osg::Vec4 ambient_back,
		osg::Vec4 diffuse_front,
		osg::Vec4 diffuse_back,
		osg::Vec4 specular_front,
		osg::Vec4 specular_back,
		osg::Vec4 emission_front,
		osg::Vec4 emission_back,
		float shininess_front,
		float shininess_back);
    virtual ~ComMaterial() {}
    virtual void realExecute();
    virtual void undo();
private:
    osg::ref_ptr< osg::Material > affected;
    //Attributes
    osg::Vec4 ambient_front_old;
    osg::Vec4 ambient_front_new;
    osg::Vec4 ambient_back_old;
    osg::Vec4 ambient_back_new;
    osg::Vec4 diffuse_front_old;
    osg::Vec4 diffuse_front_new;
    osg::Vec4 diffuse_back_old;
    osg::Vec4 diffuse_back_new;
    osg::Vec4 specular_front_old;
    osg::Vec4 specular_front_new;
    osg::Vec4 specular_back_old;
    osg::Vec4 specular_back_new;
    osg::Vec4 emission_front_old;
    osg::Vec4 emission_front_new;
    osg::Vec4 emission_back_old;
    osg::Vec4 emission_back_new;
    float shininess_front_old;
    float shininess_front_new;
    float shininess_back_old;
    float shininess_back_new;

};
#endif //__EdMaterial_H__
