#include "commaterial.h"

ComMaterial::ComMaterial(osg::Material *node,
			 osg::Vec4 ambient_front,
			 osg::Vec4 ambient_back,
			 osg::Vec4 diffuse_front,
			 osg::Vec4 diffuse_back,
			 osg::Vec4 specular_front,
			 osg::Vec4 specular_back,
			 osg::Vec4 emission_front,
			 osg::Vec4 emission_back,
			 float shininess_front,
			 float shininess_back) {
    this->affected=node;

    this->ambient_front_old = node->getAmbient(osg::Material::FRONT);
    this->ambient_back_old = node->getAmbient(osg::Material::BACK);
    this->diffuse_front_old = node->getDiffuse(osg::Material::FRONT);
    this->diffuse_back_old = node->getDiffuse(osg::Material::BACK);
    this->specular_front_old = node->getSpecular(osg::Material::FRONT);
    this->specular_back_old = node->getSpecular(osg::Material::BACK);
    this->emission_front_old = node->getEmission(osg::Material::FRONT);
    this->emission_back_old = node->getEmission(osg::Material::BACK);
    this->shininess_front_old = node->getShininess(osg::Material::FRONT);
    this->shininess_back_old = node->getShininess(osg::Material::BACK);
    this->ambient_front_new = ambient_front;
    this->ambient_back_new = ambient_back;
    this->diffuse_front_new = diffuse_front;
    this->diffuse_back_new = diffuse_back;
    this->specular_front_new = specular_front;
    this->specular_back_new = specular_back;
    this->emission_front_new = emission_front;
    this->emission_back_new = emission_back;
    this->shininess_front_new = shininess_front;
    this->shininess_back_new = shininess_back;

}

void ComMaterial::realExecute() {

    affected->setAmbient(osg::Material::FRONT,ambient_front_new);
    affected->setAmbient(osg::Material::BACK,ambient_back_new);
    affected->setDiffuse(osg::Material::FRONT,diffuse_front_new);
    affected->setDiffuse(osg::Material::BACK,diffuse_back_new);
    affected->setSpecular(osg::Material::FRONT,specular_front_new);
    affected->setSpecular(osg::Material::BACK,specular_back_new);
    affected->setEmission(osg::Material::FRONT,emission_front_new);
    affected->setEmission(osg::Material::BACK,emission_back_new);
    affected->setShininess(osg::Material::FRONT,shininess_front_new);
    affected->setShininess(osg::Material::BACK,shininess_back_new);
}

void ComMaterial::undo() {

    affected->setAmbient(osg::Material::FRONT,ambient_front_old);
    affected->setAmbient(osg::Material::BACK,ambient_back_old);
    affected->setDiffuse(osg::Material::FRONT,diffuse_front_old);
    affected->setDiffuse(osg::Material::BACK,diffuse_back_old);
    affected->setSpecular(osg::Material::FRONT,specular_front_old);
    affected->setSpecular(osg::Material::BACK,specular_back_old);
    affected->setEmission(osg::Material::FRONT,emission_front_old);
    affected->setEmission(osg::Material::BACK,emission_back_old);
    affected->setShininess(osg::Material::FRONT,shininess_front_old);
    affected->setShininess(osg::Material::BACK,shininess_back_old);
}

