#ifndef __COM_LOD_H__
#define __COM_LOD_H__

#include "command.h"
#include <osg/LOD>

class ComLOD: public Command {
    osg::ref_ptr<osg::LOD> affected;
    osg::Vec3 center_old;
    osg::LOD::RangeList ranges_old;
    osg::LOD::CenterMode center_mode_old;

    osg::Vec3 center_new;
    osg::LOD::RangeList ranges_new;
    osg::LOD::CenterMode center_mode_new;
public:
    ComLOD(osg::LOD *node,
           osg::LOD::CenterMode center_mode,
	   osg::Vec3 center,
	   osg::LOD::RangeList ranges);
    virtual ~ComLOD() {}
    virtual void realExecute();
    virtual void undo();
};

#endif
