#include "comlod.h"

ComLOD::ComLOD(osg::LOD *node,
               osg::LOD::CenterMode center_mode,
	       osg::Vec3 center,
	       osg::LOD::RangeList ranges) {
    this->affected=node;
    this->center_old=node->getCenter();
    this->center_new=center;
    this->ranges_new=ranges;
    for (unsigned i=0;i<node->getNumRanges();i++) {
        float min=node->getMinRange(i);
	float max=node->getMaxRange(i);
	osg::LOD::MinMaxPair pair(min,max);
	ranges_old.push_back(pair);
    }
    this->center_mode_old=node->getCenterMode();
    this->center_mode_new=center_mode;
}

void ComLOD::realExecute() {
    affected->setCenter(center_new);
    for (unsigned i=0;i<ranges_new.size();i++) {
	affected->setRange(i,ranges_new[i].first, ranges_new[i].second );
    }
    affected->setCenterMode(center_mode_new);
}

void ComLOD::undo() {
    affected->setCenter(center_old);
    for (unsigned i=0;i<ranges_old.size();i++) {
	affected->setRange(i,ranges_old[i].first, ranges_new[i].second );
    }
    affected->setCenterMode(center_mode_old);
}
