#ifndef __COM_LIGHT_SOURCE_H__
#define __COM_LIGHT_SOURCE_H__

#include "command.h"
#include <osg/LightSource>

class ComLightSource: public Command {
    osg::ref_ptr<osg::Light> affected;
    int number_old;
    osg::Vec4 ambient_old;
    osg::Vec4 diffuse_old;
    osg::Vec4 specular_old;
    osg::Vec4 position_old;
    osg::Vec3 direction_old;
    float constant_attenuation_old;
    float linear_attenuation_old;
    float quadratic_attenuation_old;
    float spot_exponent_old;
    float spot_cutoff_old;

    int number_new;
    osg::Vec4 ambient_new;
    osg::Vec4 diffuse_new;
    osg::Vec4 specular_new;
    osg::Vec4 position_new;
    osg::Vec3 direction_new;
    float constant_attenuation_new;
    float linear_attenuation_new;
    float quadratic_attenuation_new;
    float spot_exponent_new;
    float spot_cutoff_new;
public:
    ComLightSource(osg::Light *node, int number,
		   osg::Vec4 ambient, osg::Vec4 diffuse, osg::Vec4 specular,
		   osg::Vec4 position, osg::Vec3 direction,
		   float constant_attenuation,
		   float linear_attenuation,
		   float quadratic_attenuation,
		   float spot_exponent,
		   float spot_cutoff);
    virtual ~ComLightSource() {}
    virtual void realExecute();
    virtual void undo();
};

#endif
