#include "comlightsource.h"


ComLightSource::ComLightSource(osg::Light *light,
			       int number,
			       osg::Vec4 ambient,
			       osg::Vec4 diffuse,
			       osg::Vec4 specular,
			       osg::Vec4 position,
			       osg::Vec3 direction,
			       float constant_attenuation,
			       float linear_attenuation,
			       float quadratic_attenuation,
			       float spot_exponent,
			       float spot_cutoff) {
    this->affected=light;

    this->number_old=light->getLightNum();
    this->ambient_old=light->getAmbient();
    this->diffuse_old=light->getDiffuse();
    this->specular_old=light->getSpecular();
    this->position_old=light->getPosition();
    this->direction_old=light->getDirection();
    this->constant_attenuation_old=light->getConstantAttenuation();
    this->linear_attenuation_old=light->getLinearAttenuation();
    this->quadratic_attenuation_old=light->getQuadraticAttenuation();
    this->spot_exponent_old=light->getSpotExponent();
    this->spot_cutoff_old=light->getSpotCutoff();


    this->number_new=number;
    this->ambient_new=ambient;
    this->diffuse_new=diffuse;
    this->specular_new=specular;
    this->position_new=position;
    this->direction_new=direction;
    this->constant_attenuation_new=constant_attenuation;
    this->linear_attenuation_new=linear_attenuation;
    this->quadratic_attenuation_new=quadratic_attenuation;
    this->spot_exponent_new=spot_exponent;
    this->spot_cutoff_new=spot_cutoff;
}

void ComLightSource::realExecute() {
    affected->setLightNum(number_new);
    affected->setAmbient(ambient_new);
    affected->setDiffuse(diffuse_new);
    affected->setSpecular(specular_new);
    affected->setPosition(position_new);
    affected->setDirection(direction_new);
    affected->setConstantAttenuation(constant_attenuation_new);
    affected->setLinearAttenuation(linear_attenuation_new);
    affected->setQuadraticAttenuation(quadratic_attenuation_new);
    affected->setSpotExponent(spot_exponent_new);
    affected->setSpotCutoff(spot_cutoff_new);
}

void ComLightSource::undo() {
    affected->setLightNum(number_old);
    affected->setAmbient(ambient_old);
    affected->setDiffuse(diffuse_old);
    affected->setSpecular(specular_old);
    affected->setPosition(position_old);
    affected->setDirection(direction_old);
    affected->setConstantAttenuation(constant_attenuation_old);
    affected->setLinearAttenuation(linear_attenuation_old);
    affected->setQuadraticAttenuation(quadratic_attenuation_old);
    affected->setSpotExponent(spot_exponent_old);
    affected->setSpotCutoff(spot_cutoff_old);
}
