#ifndef __ComLightModel_H__
#define __ComLightModel_H__

#include "command.h"
#include <osg/LightModel>

class ComLightModel: public Command {
public:
    ComLightModel(osg::LightModel *node,
   osg::Vec4 ambient_intensity,
   osg::LightModel::ColorControl color_control,
   bool local_viewer,
   bool two_sided);
    virtual ~ComLightModel() {}
    virtual void realExecute();
    virtual void undo();
private:
    osg::ref_ptr< osg::LightModel > affected;
    //Attributes
    osg::Vec4 ambient_intensity_old;
    osg::Vec4 ambient_intensity_new;    
    osg::LightModel::ColorControl color_control_old;
    osg::LightModel::ColorControl color_control_new;    
    bool local_viewer_old;
    bool local_viewer_new;    
    bool two_sided_old;
    bool two_sided_new;    
    
};
#endif //__EdLightModel_H__
