#include "comlightmodel.h"

ComLightModel::ComLightModel(osg::LightModel *node,
  osg::Vec4 ambient_intensity,
  osg::LightModel::ColorControl color_control,
  bool local_viewer,
  bool two_sided) {
    this->affected=node;

    this->ambient_intensity_old = node->getAmbientIntensity();
    this->color_control_old = (osg::LightModel::ColorControl)node->getColorControl();
    this->local_viewer_old = node->getLocalViewer();
    this->two_sided_old = node->getTwoSided();
    this->ambient_intensity_new = ambient_intensity;
    this->color_control_new = color_control;
    this->local_viewer_new = local_viewer;
    this->two_sided_new = two_sided;

}

void ComLightModel::realExecute() {

    affected->setAmbientIntensity(ambient_intensity_new);
    affected->setColorControl(color_control_new);
    affected->setLocalViewer(local_viewer_new);
    affected->setTwoSided(two_sided_new);
}

void ComLightModel::undo() {

    affected->setAmbientIntensity(ambient_intensity_old);
    affected->setColorControl(color_control_old);
    affected->setLocalViewer(local_viewer_old);
    affected->setTwoSided(two_sided_old);
}

