#ifndef __ComFog_H__
#define __ComFog_H__

#include "command.h"
#include <osg/Fog>

class ComFog: public Command {
public:
    ComFog(osg::Fog *node,
   osg::Fog::Mode mode,
   float density,
   float start,
   float end,
   osg::Vec4 colour,
   GLint coord_source);
    virtual ~ComFog() {}
    virtual void realExecute();
    virtual void undo();
private:
    osg::ref_ptr< osg::Fog > affected;
    //Attributes
    osg::Fog::Mode mode_old;
    osg::Fog::Mode mode_new;    
    float density_old;
    float density_new;    
    float start_old;
    float start_new;    
    float end_old;
    float end_new;    
    osg::Vec4 colour_old;
    osg::Vec4 colour_new;    
    GLint coord_source_old;
    GLint coord_source_new;    
    
};
#endif //__EdFog_H__
