#include "comfog.h"

ComFog::ComFog(osg::Fog *node,
  osg::Fog::Mode mode,
  float density,
  float start,
  float end,
  osg::Vec4 colour,
  GLint coord_source) {
    this->affected=node;

    this->mode_old = (osg::Fog::Mode)node->getMode();
    this->density_old = node->getDensity();
    this->start_old = node->getStart();
    this->end_old = node->getEnd();
    this->colour_old = node->getColor();
    this->coord_source_old = (GLint)node->getFogCoordinateSource();
    this->mode_new = mode;
    this->density_new = density;
    this->start_new = start;
    this->end_new = end;
    this->colour_new = colour;
    this->coord_source_new = coord_source;

}

void ComFog::realExecute() {

    affected->setMode(mode_new);
    affected->setDensity(density_new);
    affected->setStart(start_new);
    affected->setEnd(end_new);
    affected->setColor(colour_new);
    affected->setFogCoordinateSource(coord_source_new);
}

void ComFog::undo() {

    affected->setMode(mode_old);
    affected->setDensity(density_old);
    affected->setStart(start_old);
    affected->setEnd(end_old);
    affected->setColor(colour_old);
    affected->setFogCoordinateSource(coord_source_old);
}

