#include <iostream>
#include "comblendfunc.h"

ComBlendFunc::ComBlendFunc(osg::BlendFunc *node,
			   osg::BlendFunc::BlendFuncMode source,
			   osg::BlendFunc::BlendFuncMode destination) {
    this->affected=node;

    this->source_old = (osg::BlendFunc::BlendFuncMode)node->getSource();
    this->destination_old = (osg::BlendFunc::BlendFuncMode)node->getDestination();
    this->source_new = source;
    this->destination_new = destination;
}

void ComBlendFunc::realExecute() {

    affected->setSource(source_new);
    affected->setDestination(destination_new);
}

void ComBlendFunc::undo() {

    affected->setSource(source_old);
    affected->setDestination(destination_old);
}

