#ifndef __COM_BILLBOARD_H__
#define __COM_BILLBOARD_H__

#include "command.h"
#include <osg/Billboard>

class ComBillboard: public Command {
    osg::ref_ptr<osg::Billboard> affected;
    osg::Billboard::Mode mode_old;
    osg::Vec3 axis_old;
    osg::Vec3 normal_old;

    osg::Billboard::Mode mode_new;
    osg::Vec3 axis_new;
    osg::Vec3 normal_new;
public:
    ComBillboard(osg::Billboard *node,
		 osg::Billboard::Mode mode,
		 osg::Vec3 axis,
		 osg::Vec3 normal);
    virtual ~ComBillboard() {}
    virtual void realExecute();
    virtual void undo();
};

#endif
