#include "combillboard.h"

ComBillboard::ComBillboard(osg::Billboard *node,
			   osg::Billboard::Mode mode,
			   osg::Vec3 axis,
			   osg::Vec3 normal) {
    this->affected=node;
    this->mode_old=node->getMode();
    this->axis_old=node->getAxis();
    this->normal_old=node->getNormal();

    this->mode_new=mode;
    this->axis_new=axis;
    this->normal_new=normal;
}

void ComBillboard::realExecute() {
    affected->setMode(mode_new);
    affected->setAxis(axis_new);
    affected->setNormal(normal_new);
    std::cout << "Executing billboard command!!!" << std::endl;
}

void ComBillboard::undo() {
    affected->setMode(mode_old);
    affected->setAxis(axis_old);
    affected->setNormal(normal_old);
}
