#ifndef __CONFIG_H__
#define __CONFIG_H__

#include <osg/Vec4>
#include <osg/Object>
#include <osg/ref_ptr>
#include "cameraview.h"

class CfgGrid: public osg::Object {
    float unitSize; ///< Distance between grid lines
    float edgeSize; ///< Size from the center axis to the edge of the grid
    osg::Vec4 grid_color; ///< Color of the grid
    osg::Vec4 axis_color; ///< Color of the center axis in the grid
public:
    CfgGrid();
    float getUnitSize() const { return unitSize; }
    void setUnitSize(float v) { unitSize=v; }

    float getEdgeSize() const { return edgeSize; }
    void setEdgeSize(float v) { edgeSize=v; }

    osg::Vec4 getGridColor() const { return grid_color; }
    void setGridColor(osg::Vec4 v) { grid_color=v; }

    osg::Vec4 getAxisColor() const { return axis_color; }
    void setAxisColor(osg::Vec4 v) { axis_color=v; }


    virtual osg::Object* cloneType() const  { return new CfgGrid(); }
    virtual osg::Object* clone(const osg::CopyOp&) const { return NULL; }
    virtual const char* libraryName() const { return "osgedit"; }
    virtual const char* className() const { return "osgedit::CfgGrid"; }
};

class CfgView: public osg::Object {
    CameraView::AxisSystem axis_system;
    CameraView::ProjectionType projection_type;
    CameraView::ViewType view_type;
public:
    CfgView();
    CameraView::AxisSystem getAxisSystem() const { return axis_system; }
    void setAxisSystem(CameraView::AxisSystem sys) { axis_system=sys; }

    CameraView::ProjectionType getProjectionType() const { return projection_type; }
    void setProjectionType(CameraView::ProjectionType t) { projection_type=t; }

    CameraView::ViewType getViewType() const { return view_type; }
    void setViewType(CameraView::ViewType t) { view_type=t; }

    virtual osg::Object* cloneType() const  { return new CfgView(); }
    virtual osg::Object* clone(const osg::CopyOp&) const { return NULL; }
    virtual const char* libraryName() const { return "osgedit"; }
    virtual const char* className() const { return "osgedit::CfgView"; }
};

class AppConfig: public osg::Object {
    osg::Vec4 background_color;
    osg::ref_ptr<CfgGrid> grid; ///< Configuration of the grid
    osg::ref_ptr<CfgView> view; ///< Configuration of the 3D viewing
public:
    CfgGrid *getCfgGrid() { return grid.get(); }

    CfgView *getCfgView() { return view.get(); }

    osg::Vec4 getBackgroundColor() const { return background_color; }
    void setBackgroundColor(osg::Vec4 color) { background_color=color; }



    static AppConfig *instance() { return _instance; }

    virtual osg::Object* cloneType() const  { return new AppConfig(); }
    virtual osg::Object* clone(const osg::CopyOp&) const { return NULL; }
    virtual const char* libraryName() const { return "osgedit"; }
    virtual const char* className() const { return "osgedit::AppConfig"; }

private:
    AppConfig();
    static AppConfig *_instance;
};

#endif
