//---------------------------------------------------------------------------
// SelfImage - Disk image manipulation program
// SelfImage_TImageStore.h - TImageStore class header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of SelfImage.
//
// SelfImage is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// SelfImage is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef SelfImage_TImageStoreH
#define SelfImage_TImageStoreH
//---------------------------------------------------------------------------
enum TImageStoreType { isFile, isDrive };
struct TTargetGeometry {
  __int64 Bytes;
  __int64 Sectors;
  int BytesPerSector;
};
class TImageStore {
  public:
    __property TImageStoreType Type  = {read = FType};
    __property AnsiString      FileName = {read = FFileName};
    __property TTargetGeometry Geometry = {read = FGeometry};

    __fastcall TImageStore(TImageStoreType isType, AnsiString Target, bool Writable = false);
    __fastcall ~TImageStore();
    bool __fastcall Read(void * buffer, int nLength, unsigned *nBytesRead);
    bool __fastcall Write(void *buffer, int nLength, unsigned *nBytesWritten);

  protected:

  private:
    TImageStoreType FType;
    AnsiString      FFileName;
    bool            bWriteAccess;
    HANDLE          hHandle;
    TTargetGeometry FGeometry;

    bool __fastcall Open(void);
    bool __fastcall Close(void);

};  // class TImageStore
//---------------------------------------------------------------------------
#endif
 