//------------------------------ $Keywords ----------------------------------
// SelfImage - Disk image manipulation program
// SelfImage_Buffer.h - TImageBuffer class header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of SelfImage.
//
// SelfImage is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// SelfImage is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 0 $ $Revision: 2 $
/*
$History: **** V 0.1 by kfitzner ****
$History: * selfimage_timagebuffer.cpp - 2005-11-07 2:39:38 AM - 11089 Bytes
$History: * selfimage_timagebuffer.h - 2005-11-07 2:39:38 AM - 3741 Bytes
$History: * Initial check-in
$History: **** Latest ** V 0.2 by kfitzner ** 2005-11-12 5:22:11 PM ****
$History: * Typo in copyright area + change in program description
*/
//---------------------------------------------------------------------------
#ifndef SelfImage_TImageBufferH
#define SelfImage_TImageBufferH
//---------------------------------------------------------------------------
#include <SyncObjs.hpp>
//---------------------------------------------------------------------------
#define SIZE_NOT_SET 0xFFFFFFFFl
//---------------------------------------------------------------------------
// TBufferChunk class - each instance of this class is one of a group of
// buffer chunks.  These chunks hold data as they pass from the read to the
// write threads.  Allocating chunks is done through the main TImageBuffer
// class.
// Memory used in these chunks is guaranteed to be alligned on a page
// boundary - thus on x86 it will be a multiple of any known disk sector
// size (as required when unbuffered file I/O is performed).
//
class TBufferChunk {
  public:
    TBufferChunk(int nSize, int nIndex);
    ~TBufferChunk();
    void inline __fastcall Reset(void) { FEOF = false; FUsedSize = SIZE_NOT_SET; } 
    __property unsigned MaxSize = {read = FMaxSize};
    __property unsigned Size = {read = GetSize, write = FUsedSize};
    __property bool     EOF = {read = FEOF, write = FEOF};
    __property void    *Data  = {read = FData};
    __property int      Index = {read = FIndex};

  private:
    unsigned inline __fastcall GetSize() { return (FUsedSize!=SIZE_NOT_SET)?FUsedSize:FMaxSize; };
    unsigned FMaxSize;
    unsigned FUsedSize;
    bool FEOF;
    void *FData;
    int FIndex;
};  // class TBufferChunk
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// TImageBuffer class - this class acts as
enum TBufferChunkState {csFree, csAllocRead, csAllocWrite, csFinishedWrite};
class TImageBuffer {
  public:
    __fastcall TImageBuffer(int ChunkSize, int ChunkCount);
    TBufferChunk * __fastcall GetChunk(TBufferChunkState Purpose, bool *TerminationFlag);
    bool _fastcall ReleaseChunk(TBufferChunk *Chunk);

  private:
    TBufferChunk **Chunks;
    TBufferChunkState *ChunkStates;
    unsigned ChunkCount;         // Must be power of two
    unsigned ChunkSize;
    unsigned IndexMask;          // Mask for chunk counters - used to wrap the ring buffer
    unsigned NextReadChunkIndex, NextWriteChunkIndex;
    TMultiReadExclusiveWriteSynchronizer *Sync;
    TEvent *ReadChunkReady, *WriteChunkReady;
};  // class TImageBuffer
//---------------------------------------------------------------------------
#endif
