//------------------------------ $Keywords ----------------------------------
// SelfImage - Disk image manipulation program
// SelfImage_ProgressDialog.cpp - Simple progress bar dialog
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of SelfImage.
//
// SelfImage is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// SelfImage is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 0 $ $Revision: 3 $
/*
$History: **** V 0.1 by kfitzner ****
$History: * selfimage_progressdialog.cpp - 2005-11-07 12:52:50 AM - 1697 Bytes
$History: * selfimage_progressdialog.dfm - 2005-11-07 12:53:34 AM - 1330 Bytes
$History: * selfimage_progressdialog.h - 2005-11-07 12:51:40 AM - 1212 Bytes
$History: * selfimage_progressdialog.ddp - 2005-11-07 12:54:40 AM - 51 Bytes
$History: * Initial check-in
$History: **** V 0.2 by kfitzner ****
$History: * selfimage_progressdialog.cpp - 2005-11-12 5:10:52 PM - 4188 Bytes
$History: * selfimage_progressdialog.dfm - 2005-11-07 12:53:34 AM - 1330 Bytes
$History: * selfimage_progressdialog.h - 2005-11-12 5:10:24 PM - 2232 Bytes
$History: * selfimage_progressdialog.ddp - 2005-11-12 5:10:52 PM - 51 Bytes
$History: * Add copyright notice and VCS history/version tags
$History: **** Latest ** V 0.3 by kfitzner ** 2005-11-12 5:16:10 PM ****
$History: * Typo in copyright area
*/
//----------------------------- $NoKeywords ---------------------------------

//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 12 Nov 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// A very simple progress bar dialog - nothing special here.
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "SelfImage_ProgressDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "JvBevel"
#pragma link "JvComponent"
#pragma link "JvExControls"
#pragma link "JvExExtCtrls"
#pragma link "JvSpecialProgress"
#pragma resource "*.dfm"
TProgressDialog *ProgressDialog;
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Constructor
//
__fastcall TProgressDialog::TProgressDialog(TComponent* Owner): TForm(Owner)
{
  ProgressBar->Position = 0;
  ProgressBar->Maximum = 0;
  lblCaption->Caption = "";
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Display the form - call this function to make the form visible.  Caption
// is a blurb displayed just under the progress bar.  InitialPosition is
// the initial value of the progress bar (usually zero), and Max is the
// maximum value.
//
void __fastcall TProgressDialog::Display(AnsiString Caption, int InitialPosition, int Max)
{
  Position = InitialPosition;
  lblCaption->Caption = Caption;
  ProgressBar->Maximum = Max;
  ProgressBar->Position = InitialPosition;
  Show();
  Update();
}  // void __fastcall Display(int Position, int Max)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Increase the progressbar posision by Step.  The form is repainted after
// to ensure the user sees the change.
//
void __fastcall TProgressDialog::StepBy(int Step)
{
  ProgressBar->Position += Step;
  Update();
}  // void __fastcall TProgressDialog::StepBy(int Step)
//---------------------------------------------------------------------------
