//------------------------------ $Keywords ----------------------------------
// SelfImage - Disk image manipulation program
// SelfImage_Preferences.cpp - Preferences form
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of SelfImage.
//
// SelfImage is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// SelfImage is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 0 $ $Revision: 3 $
/*
$History: **** V 0.1 by kfitzner ****
$History: * selfimage_preferences.cpp - 2005-11-12 5:17:31 PM - 4304 Bytes
$History: * selfimage_preferences.dfm - 2005-11-12 4:59:34 PM - 1374 Bytes
$History: * selfimage_preferences.h - 2005-11-12 5:04:06 PM - 2105 Bytes
$History: * selfimage_preferences.ddp - 2005-11-12 5:04:24 PM - 51 Bytes
$History: * Initial check-in
$History: **** V 0.2 by kfitzner ****
$History: * selfimage_preferences.cpp - 2005-11-15 5:29:33 PM - 4878 Bytes
$History: * selfimage_preferences.dfm - 2005-11-14 5:09:04 PM - 1574 Bytes
$History: * selfimage_preferences.h - 2005-11-14 5:09:04 PM - 2142 Bytes
$History: * selfimage_preferences.ddp - 2005-11-14 5:23:48 PM - 51 Bytes
$History: * Add option to disable warning when writing to a partition
$History: **** Latest ** V 0.3 by kfitzner ** 2005-11-18 3:55:03 PM ****
$History: * Add help button to form
*/
//----------------------------  $NoKeywords ---------------------------------

//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 12 Nov 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// A simple preferences form.  Right now it's probably not strictly needed
// (it only has two entried - window position saving and new version
// notification), but it's better to have something in place to make
// future expansion easier.  Besides, the TConfiguration class makes this
// a breeze - really this is just a visual interface to that class.
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TConfiguration.h"
#include "SelfImage_Preferences.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
extern TConfiguration *SelfImageConfig;
TformSelfImagePreferences *formSelfImagePreferences;
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Form constructor
//
__fastcall TformSelfImagePreferences::TformSelfImagePreferences(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// OnShow event handler
//
void __fastcall TformSelfImagePreferences::FormShow(TObject *Sender)
{
  chbVersionNotify->Checked = SelfImageConfig->Values["Update Notify"];
  chbWindowPositions->Checked = SelfImageConfig->Values["Remember Positions"];
  chbWriteWarning->Checked = SelfImageConfig->Values["NoDirectWriteWarn"];
}  // void __fastcall TformSelfImagePreferences::FormShow(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Ok button OnClick event handler - user clicked 'Ok' so we update the
// configuration with the new preferences
//
void __fastcall TformSelfImagePreferences::btnOkClick(TObject *Sender)
{
  SelfImageConfig->Values["Update Notify"] = chbVersionNotify->Checked;
  SelfImageConfig->Values["Remember Positions"] = chbWindowPositions->Checked;
  SelfImageConfig->Values["NoDirectWriteWarn"] = chbWriteWarning->Checked;
  // If the user turns off the option to remember the window positions, then reset any
  // position information that may be stored.
  if (!chbWindowPositions->Checked) {
      SelfImageConfig->Values["WindowTop"] = -1;
      SelfImageConfig->Values["WindowLeft"] = -1;
      SelfImageConfig->Values["WindowWidth"] = -1;
  }  // if (!chbWindowPositions->Checked)
  Close();
}  // void __fastcall TformSelfImagePreferences::btnOkClick(TObject *Sender)
//---------------------------------------------------------------------------
