//------------------------------ $Keywords ----------------------------------
// SelfImage - Disk image manipulation program
// SelfImage_MainForm.h - Main form header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of SelfImage.
//
// SelfImage is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// SelfImage is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef SelfImage_MainFormH
#define SelfImage_MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <ExtCtrls.hpp>
#include <Mask.hpp>
#include <StdCtrls.hpp>
#include <ComCtrls.hpp>
#include "SelfImage_TDriveList.h"
#include "SelfImage_ReadThread.h"
#include "SelfImage_WriteThread.h"
#include "JvBevel.hpp"
#include "JvComponent.hpp"
#include "JvExControls.hpp"
#include "JvExExtCtrls.hpp"
#include "JvExMask.hpp"
#include "JvSpecialProgress.hpp"
#include "JvToolEdit.hpp"
#include <Menus.hpp>
#include <Buttons.hpp>
//---------------------------------------------------------------------------
enum TMainFormVisualMode { modeSetup, modeOperating };
//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
  TGroupBox *gbInput;
  TRadioButton *radioSourceFile;
  TJvFilenameEdit *edtSourceFile;
  TRadioButton *radioSourceDrive;
  TComboBox *cmbSourceDrive;
  TLabel *lblSourceSize;
  TLabel *lblSourceSizeValue;
  TGroupBox *gbOutput;
  TRadioButton *radioTargetFile;
  TJvFilenameEdit *edtTargetFile;
  TRadioButton *radioTargetDrive;
  TComboBox *cmbTargetDrive;
  TLabel *lblTargetDriveSize;
  TLabel *lblTargetDriveSizeValue;
  TButton *btnOk;
  TButton *btnCancel;
  TSpeedButton *btnHelp;
  TGroupBox *gbStatus;
  TJvSpecialProgress *ProgressBar;
  TJvBevel *ProgressBarBevel;
  TLabel *lblBytesWritten;
  TLabel *lblBytesTotal;
  TLabel *lblBytesWrittenValue;
  TLabel *lblBytesTotalValue;
  TLabel *lblWriteSpeedValue;
  TLabel *lblWriteSpeed;
  TLabel *lblOverallSpeed;
  TLabel *lblOverallSpeedValue;
  TTimer *UpdateTimer;
  TMainMenu *MainMenu;
  TMenuItem *menu_File;
  TMenuItem *menu_File_Start;
  TMenuItem *N1;
  TMenuItem *menu_File_Exit;
  TMenuItem *menu_Edit;
  TMenuItem *menu_Edit_Refresh;
  TMenuItem *N2;
  TMenuItem *menu_Edit_Preferences;
  TMenuItem *menu_Help;
  TMenuItem *menu_Help_Contents;
  TMenuItem *N3;
  TMenuItem *menu_Help_Overview;
  TMenuItem *menu_Help_Using;
  TMenuItem *menu_Help_Partitions;
  TMenuItem *N4;
  TMenuItem *menu_Help_About;

  void __fastcall FormShow(TObject *Sender);
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall radioSourceFileClick(TObject *Sender);
  void __fastcall radioTargetFileClick(TObject *Sender);
  void __fastcall cmbSourceDriveChange(TObject *Sender);
  void __fastcall cmbTargetDriveChange(TObject *Sender);
  void __fastcall SetVisualDefaults(TObject *Sender);
  void __fastcall btnOkClick(TObject *Sender);
  void __fastcall btnCancelClick(TObject *Sender);
  void __fastcall menu_File_ExitClick(TObject *Sender);
  void __fastcall menu_Edit_RefreshClick(TObject *Sender);
  void __fastcall menu_Edit_PreferencesClick(TObject *Sender);
  void __fastcall menu_Help_ItemsClick(TObject *Sender);
  void __fastcall menu_Help_AboutClick(TObject *Sender);
  void __fastcall btnHelpClick(TObject *Sender);
  void __fastcall UpdateTimerTimer(TObject *Sender);

private:	// User declarations
  __int64 SourceSize;
  TDriveList *DriveList;
  TImageStore *SourceImage, *TargetImage;
  TImageBuffer *Buffer;
  TSelfImageReadThread *ReadThread;
  TSelfImageWriteThread *WriteThread;
  unsigned __int64 nnTotalBytes;
  TMainFormVisualMode CurrentMode;

  bool bCancelOperation;

  void __fastcall RefreshDriveList(void);
  void __fastcall VisualMode(TMainFormVisualMode Mode);
  void __fastcall UpdateStatus(bool bInit = false);
  bool __fastcall SanityCheck(void);

public:		// User declarations
  __fastcall TMainForm(TComponent* Owner);

};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
