/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/*===========================================================================
 * 
 * Project : freyja
 * Author  : Terry 'Mongoose' Hendrix II
 * Website : http://www.icculus.org/freyja/
 * Email   : mongooseichiban@gmail.com
 * Object  : 
 * License : No use w/o permission (C) 2004-2006 Mongoose
 * Comments: This is the Python plugin ABI.
 *
 *           This file was generated by Mongoose's UpdateBindings.py
 *           - Mongoose <mongooseichiban@gmail.com>
 *
 * 2006.12.12:
 * Mongoose - Generated, Based on C ABI for freyja
 ==========================================================================*/

#include "SkeletonABI.h"
#include "PythonABI.h"
#include "TextureABI.h"
#include "ModelABI.h"
#include "BoneABI.h"
#include "LightABI.h"
#include "MaterialABI.h"
#include "PakABI.h"
#include "MeshABI.h"
#include "freyja.h"
#ifdef USING_PYTHON
#include <python2.4/Python.h>


PyObject *py_freyjaSkeletonCreate(PyObject *self, PyObject *args)
{
	freyjaSkeletonCreate();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaSkeletonPoolClear(PyObject *self, PyObject *args)
{
	freyjaSkeletonPoolClear();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaSkeletonDelete(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;

	if (!PyArg_ParseTuple(args, "i", &skeletonIndex))
		return NULL;

	freyjaSkeletonDelete(skeletonIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaSkeletonUpdateBones(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;

	if (!PyArg_ParseTuple(args, "i", &skeletonIndex))
		return NULL;

	freyjaSkeletonUpdateBones(skeletonIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaSkeletonAddBone(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "ii", &skeletonIndex, &boneIndex))
		return NULL;

	freyjaSkeletonAddBone(skeletonIndex, boneIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaSkeletonRootIndex(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "ii", &skeletonIndex, &boneIndex))
		return NULL;

	freyjaSkeletonRootIndex(skeletonIndex, boneIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaSkeletonTransform(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	freyja_transform_action_t action;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iifff", &boneIndex, &action, &x, &y, &z))
		return NULL;

	freyjaSkeletonTransform(boneIndex, action, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetSkeletonCount(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaGetSkeletonCount());
}


PyObject *py_freyjaGetSkeletonBoneCount(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;

	if (!PyArg_ParseTuple(args, "i", &skeletonIndex))
		return NULL;

	return PyInt_FromLong(freyjaGetSkeletonBoneCount(skeletonIndex));
}


PyObject *py_freyjaGetSkeletonBoneIndex(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;
	uint32 element;

	if (!PyArg_ParseTuple(args, "ii", &skeletonIndex, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetSkeletonBoneIndex(skeletonIndex, element));
}


PyObject *py_freyjaGetSkeletonRootIndex(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;

	if (!PyArg_ParseTuple(args, "i", &skeletonIndex))
		return NULL;

	return PyInt_FromLong(freyjaGetSkeletonRootIndex(skeletonIndex));
}


PyObject *py_freyjaSkeletonName(PyObject *self, PyObject *args)
{
	index_t skeleton;
	char* name;

	if (!PyArg_ParseTuple(args, "is", &skeleton, &name))
		return NULL;

	freyjaSkeletonName(skeleton, name);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetSkeletonName(PyObject *self, PyObject *args)
{
	index_t skeleton;

	if (!PyArg_ParseTuple(args, "i", &skeleton))
		return NULL;

	return PyString_FromString(freyjaGetSkeletonName(skeleton));
}


PyObject *py_freyjaPython1s(PyObject *self, PyObject *args)
{
	char* plugin;
	char* symbol;
	char* s;

	if (!PyArg_ParseTuple(args, "sss", &plugin, &symbol, &s))
		return NULL;

	freyjaPython1s(plugin, symbol, s);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaTextureCreateFilename(PyObject *self, PyObject *args)
{
	char* filename;

	if (!PyArg_ParseTuple(args, "s", &filename))
		return NULL;

	freyjaTextureCreateFilename(filename);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaTextureCreateBuffer(PyObject *self, PyObject *args)
{
	byte* image;
	uint32 byteDepth;
	uint32 width;
	uint32 height;
	freyja_colormode_t type;

	if (!PyArg_ParseTuple(args, "iiiii", &image, &byteDepth, &width, &height, &type))
		return NULL;

	return PyInt_FromLong(freyjaTextureCreateBuffer(image, byteDepth, width, height, type));
}


PyObject *py_freyjaTextureDelete(PyObject *self, PyObject *args)
{
	index_t textureIndex;

	if (!PyArg_ParseTuple(args, "i", &textureIndex))
		return NULL;

	freyjaTextureDelete(textureIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetTextureImage(PyObject *self, PyObject *args)
{
	index_t textureIndex;
	uint32 w;
	uint32 h;
	uint32 bitDepth;
	uint32 type;
	byte* image;

	if (!PyArg_ParseTuple(args, "iiiiii", &textureIndex, &w, &h, &bitDepth, &type, &image))
		return NULL;

	freyjaGetTextureImage(textureIndex, w, h, bitDepth, type, image);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetTexturePoolCount(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaGetTexturePoolCount());
}


PyObject *py_freyjaGetTextureCount(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaGetTextureCount());
}


PyObject *py_freyjaGetModelCount(PyObject *self, PyObject *args)
{
	freyjaGetModelCount();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaModelCreate(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaModelCreate());
}


PyObject *py_freyjaModelAddSkeleton(PyObject *self, PyObject *args)
{
	index_t model;
	index_t skeleton;

	if (!PyArg_ParseTuple(args, "ii", &model, &skeleton))
		return NULL;

	freyjaModelAddSkeleton(model, skeleton);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaModelAddMesh(PyObject *self, PyObject *args)
{
	index_t model;
	index_t mesh;

	if (!PyArg_ParseTuple(args, "ii", &model, &mesh))
		return NULL;

	freyjaModelAddMesh(model, mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetModelFlags(PyObject *self, PyObject *args)
{
	index_t model;

	if (!PyArg_ParseTuple(args, "i", &model))
		return NULL;

	return PyInt_FromLong(freyjaGetModelFlags(model));
}


PyObject *py_freyjaGetModelMeshCount(PyObject *self, PyObject *args)
{
	index_t model;

	if (!PyArg_ParseTuple(args, "i", &model))
		return NULL;

	return PyInt_FromLong(freyjaGetModelMeshCount(model));
}


PyObject *py_freyjaGetModelMeshIndex(PyObject *self, PyObject *args)
{
	index_t model;
	uint32 element;

	if (!PyArg_ParseTuple(args, "ii", &model, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetModelMeshIndex(model, element));
}


PyObject *py_freyjaGetModelSkeleton(PyObject *self, PyObject *args)
{
	index_t model;

	if (!PyArg_ParseTuple(args, "i", &model))
		return NULL;

	return PyInt_FromLong(freyjaGetModelSkeleton(model));
}


PyObject *py_freyjaModelTransform(PyObject *self, PyObject *args)
{
	index_t model;
	freyja_transform_action_t action;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iifff", &model, &action, &x, &y, &z))
		return NULL;

	freyjaModelTransform(model, action, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaModelClear(PyObject *self, PyObject *args)
{
	index_t model;

	if (!PyArg_ParseTuple(args, "i", &model))
		return NULL;

	freyjaModelClear(model);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneCount(PyObject *self, PyObject *args)
{
	freyjaGetBoneCount();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBonePoolClear(PyObject *self, PyObject *args)
{
	freyjaBonePoolClear();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneCreate(PyObject *self, PyObject *args)
{
	index_t skeletonIndex;

	if (!PyArg_ParseTuple(args, "i", &skeletonIndex))
		return NULL;

	return PyInt_FromLong(freyjaBoneCreate(skeletonIndex));
}


PyObject *py_freyjaBoneDelete(PyObject *self, PyObject *args)
{
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "i", &boneIndex))
		return NULL;

	freyjaBoneDelete(boneIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneFlags(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	byte flags;

	if (!PyArg_ParseTuple(args, "ii", &boneIndex, &flags))
		return NULL;

	freyjaBoneFlags(boneIndex, flags);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneParent(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	index_t parentIndex;

	if (!PyArg_ParseTuple(args, "ii", &boneIndex, &parentIndex))
		return NULL;

	freyjaBoneParent(boneIndex, parentIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneName(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	char* name;

	if (!PyArg_ParseTuple(args, "is", &boneIndex, &name))
		return NULL;

	freyjaBoneName(boneIndex, name);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRemoveChild(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	index_t childIndex;

	if (!PyArg_ParseTuple(args, "ii", &boneIndex, &childIndex))
		return NULL;

	freyjaBoneRemoveChild(boneIndex, childIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneAddChild(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	index_t childIndex;

	if (!PyArg_ParseTuple(args, "ii", &boneIndex, &childIndex))
		return NULL;

	freyjaBoneAddChild(boneIndex, childIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneTranslate3f(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, &x, &y, &z))
		return NULL;

	freyjaBoneTranslate3f(boneIndex, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneTranslate3fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaBoneTranslate3fv(boneIndex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRotateEuler3f(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec_t p;
	vec_t h;
	vec_t r;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, &p, &h, &r))
		return NULL;

	freyjaBoneRotateEuler3f(boneIndex, p, h, r);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRotateEuler3fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec3_t phr;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, phr+0, phr+1, phr+2))
		return NULL;

	freyjaBoneRotateEuler3fv(boneIndex, phr);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRotateQuat4f(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec_t w;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iffff", &boneIndex, &w, &x, &y, &z))
		return NULL;

	freyjaBoneRotateQuat4f(boneIndex, w, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRotateQuat4fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec4_t wxyz;

	if (!PyArg_ParseTuple(args, "iffff", &boneIndex, wxyz+0, wxyz+1, wxyz+2, wxyz+3))
		return NULL;

	freyjaBoneRotateQuat4fv(boneIndex, wxyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneRotationQuat4fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec4_t wxyz;

	if (!PyArg_ParseTuple(args, "iffff", &boneIndex, wxyz+0, wxyz+1, wxyz+2, wxyz+3))
		return NULL;

	freyjaGetBoneRotationQuat4fv(boneIndex, wxyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneRotationEuler3fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec3_t phr;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, phr+0, phr+1, phr+2))
		return NULL;

	freyjaGetBoneRotationEuler3fv(boneIndex, phr);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneTransform(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	freyja_transform_action_t action;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iifff", &boneIndex, &action, &x, &y, &z))
		return NULL;

	freyjaBoneTransform(boneIndex, action, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneTransform3fv(PyObject *self, PyObject *args)
{
	index_t bone;
	freyja_transform_action_t action;
	vec3_t v;

	if (!PyArg_ParseTuple(args, "iifff", &bone, &action, v+0, v+1, v+2))
		return NULL;

	freyjaBoneTransform3fv(bone, action, v);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneNameString(PyObject *self, PyObject *args)
{
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "i", &boneIndex))
		return NULL;

	return PyString_FromString(freyjaGetBoneNameString(boneIndex));
}


PyObject *py_freyjaGetBoneName(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	uint32 size;
	char* name;

	if (!PyArg_ParseTuple(args, "iis", &boneIndex, &size, &name))
		return NULL;

	freyjaGetBoneName(boneIndex, size, name);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneParent(PyObject *self, PyObject *args)
{
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "i", &boneIndex))
		return NULL;

	return PyInt_FromLong(freyjaGetBoneParent(boneIndex));
}


PyObject *py_freyjaGetBoneBindPose16fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "i", &boneIndex))
		return NULL;

#if FIXME
	/* No support for returning pointers yet... */
	return PyFloat_FromDouble(freyjaGetBoneBindPose16fv(boneIndex));
#endif // FIXME

	return NULL;
}


PyObject *py_freyjaGetBoneWorldPos3fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaGetBoneWorldPos3fv(boneIndex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneTranslation3fv(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "ifff", &boneIndex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaGetBoneTranslation3fv(boneIndex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetBoneSkeletonIndex(PyObject *self, PyObject *args)
{
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "i", &boneIndex))
		return NULL;

	return PyInt_FromLong(freyjaGetBoneSkeletonIndex(boneIndex));
}


PyObject *py_freyjaGetBoneChild(PyObject *self, PyObject *args)
{
	index_t boneIndex;
	uint32 element;

	if (!PyArg_ParseTuple(args, "ii", &boneIndex, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetBoneChild(boneIndex, element));
}


PyObject *py_freyjaGetBoneChildCount(PyObject *self, PyObject *args)
{
	index_t boneIndex;

	if (!PyArg_ParseTuple(args, "i", &boneIndex))
		return NULL;

	return PyInt_FromLong(freyjaGetBoneChildCount(boneIndex));
}


PyObject *py_freyjaBoneUpdateBindPose(PyObject *self, PyObject *args)
{
	index_t bone;

	if (!PyArg_ParseTuple(args, "i", &bone))
		return NULL;

	freyjaBoneUpdateBindPose(bone);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneGetBindTransform(PyObject *self, PyObject *args)
{
	index_t bone;
	matrix_t m;

	if (!PyArg_ParseTuple(args, "iffffffffffffffff", &bone, m+0, m+1, m+2, m+3, m+4, m+5, m+6, m+7, m+8, m+9, m+10, m+11, m+12, m+13, m+14))
		return NULL;

	freyjaBoneGetBindTransform(bone, m);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneGetBindTransformInverse(PyObject *self, PyObject *args)
{
	index_t bone;
	matrix_t m;

	if (!PyArg_ParseTuple(args, "iffffffffffffffff", &bone, m+0, m+1, m+2, m+3, m+4, m+5, m+6, m+7, m+8, m+9, m+10, m+11, m+12, m+13, m+14))
		return NULL;

	freyjaBoneGetBindTransformInverse(bone, m);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneBindTransformVertex(PyObject *self, PyObject *args)
{
	index_t bone;
	vec3_t p;
	vec_t w;

	if (!PyArg_ParseTuple(args, "iffff", &bone, p+0, p+1, p+2, &w))
		return NULL;

	freyjaBoneBindTransformVertex(bone, p, w);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneTrackNew(PyObject *self, PyObject *args)
{
	index_t bone;

	if (!PyArg_ParseTuple(args, "i", &bone))
		return NULL;

	return PyInt_FromLong(freyjaBoneTrackNew(bone));
}


PyObject *py_freyjaBoneTrackDuration(PyObject *self, PyObject *args)
{
	index_t bone;
	index_t track;
	vec_t duration;

	if (!PyArg_ParseTuple(args, "iif", &bone, &track, &duration))
		return NULL;

	freyjaBoneTrackDuration(bone, track, duration);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneTrackRate(PyObject *self, PyObject *args)
{
	index_t bone;
	index_t track;
	vec_t fps;

	if (!PyArg_ParseTuple(args, "iif", &bone, &track, &fps))
		return NULL;

	freyjaBoneTrackRate(bone, track, fps);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneKeyFrameNew(PyObject *self, PyObject *args)
{
	index_t bone;
	index_t track;
	vec_t time;

	if (!PyArg_ParseTuple(args, "iif", &bone, &track, &time))
		return NULL;

	return PyInt_FromLong(freyjaBoneKeyFrameNew(bone, track, time));
}


PyObject *py_freyjaBonePosKeyFrame3f(PyObject *self, PyObject *args)
{
	index_t bone;
	index_t track;
	index_t key;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iiifff", &bone, &track, &key, &x, &y, &z))
		return NULL;

	freyjaBonePosKeyFrame3f(bone, track, key, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRotKeyFrameEuler3f(PyObject *self, PyObject *args)
{
	index_t bone;
	index_t track;
	index_t key;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iiifff", &bone, &track, &key, &x, &y, &z))
		return NULL;

	freyjaBoneRotKeyFrameEuler3f(bone, track, key, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaBoneRotKeyFrameQuat4f(PyObject *self, PyObject *args)
{
	index_t bone;
	index_t track;
	index_t key;
	vec_t w;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iiiffff", &bone, &track, &key, &w, &x, &y, &z))
		return NULL;

	freyjaBoneRotKeyFrameQuat4f(bone, track, key, w, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaLightCreate(PyObject *self, PyObject *args)
{
	freyjaLightCreate();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetLightCount(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaGetLightCount());
}


PyObject *py_freyjaLightDelete(PyObject *self, PyObject *args)
{
	index_t lightIndex;

	if (!PyArg_ParseTuple(args, "i", &lightIndex))
		return NULL;

	freyjaLightDelete(lightIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaLightPosition4v(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t position;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, position+0, position+1, position+2, position+3))
		return NULL;

	freyjaLightPosition4v(lightIndex, position);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaLightAmbient(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t ambient;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, ambient+0, ambient+1, ambient+2, ambient+3))
		return NULL;

	freyjaLightAmbient(lightIndex, ambient);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaLightDiffuse(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t diffuse;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, diffuse+0, diffuse+1, diffuse+2, diffuse+3))
		return NULL;

	freyjaLightDiffuse(lightIndex, diffuse);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaLightSpecular(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t specular;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, specular+0, specular+1, specular+2, specular+3))
		return NULL;

	freyjaLightSpecular(lightIndex, specular);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetLightPosition4v(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t position;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, position+0, position+1, position+2, position+3))
		return NULL;

	freyjaGetLightPosition4v(lightIndex, position);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetLightAmbient(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t ambient;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, ambient+0, ambient+1, ambient+2, ambient+3))
		return NULL;

	freyjaGetLightAmbient(lightIndex, ambient);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetLightDiffuse(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t diffuse;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, diffuse+0, diffuse+1, diffuse+2, diffuse+3))
		return NULL;

	freyjaGetLightDiffuse(lightIndex, diffuse);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetLightSpecular(PyObject *self, PyObject *args)
{
	index_t lightIndex;
	vec4_t specular;

	if (!PyArg_ParseTuple(args, "iffff", &lightIndex, specular+0, specular+1, specular+2, specular+3))
		return NULL;

	freyjaGetLightSpecular(lightIndex, specular);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialCreate(PyObject *self, PyObject *args)
{
	freyjaMaterialCreate();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialClearAll(PyObject *self, PyObject *args)
{
	freyjaMaterialClearAll();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMaterialCount(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaGetMaterialCount());
}


PyObject *py_freyjaGetMaterialIndex(PyObject *self, PyObject *args)
{
	index_t material;
	uint32 element;

	if (!PyArg_ParseTuple(args, "ii", &material, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetMaterialIndex(material, element));
}


PyObject *py_freyjaGetMaterialName(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyString_FromString(freyjaGetMaterialName(material));
}


PyObject *py_freyjaGetMaterialFlags(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyInt_FromLong(freyjaGetMaterialFlags(material));
}


PyObject *py_freyjaGetMaterialTexture(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyInt_FromLong(freyjaGetMaterialTexture(material));
}


PyObject *py_freyjaGetMaterialTextureName(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyString_FromString(freyjaGetMaterialTextureName(material));
}


PyObject *py_freyjaGetMaterialAmbient(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t ambient;

	if (!PyArg_ParseTuple(args, "iffff", &material, ambient+0, ambient+1, ambient+2, ambient+3))
		return NULL;

	freyjaGetMaterialAmbient(material, ambient);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMaterialDiffuse(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t diffuse;

	if (!PyArg_ParseTuple(args, "iffff", &material, diffuse+0, diffuse+1, diffuse+2, diffuse+3))
		return NULL;

	freyjaGetMaterialDiffuse(material, diffuse);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMaterialSpecular(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t specular;

	if (!PyArg_ParseTuple(args, "iffff", &material, specular+0, specular+1, specular+2, specular+3))
		return NULL;

	freyjaGetMaterialSpecular(material, specular);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMaterialEmissive(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t emissive;

	if (!PyArg_ParseTuple(args, "iffff", &material, emissive+0, emissive+1, emissive+2, emissive+3))
		return NULL;

	freyjaGetMaterialEmissive(material, emissive);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMaterialShininess(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyFloat_FromDouble(freyjaGetMaterialShininess(material));
}


PyObject *py_freyjaGetMaterialTransparency(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyFloat_FromDouble(freyjaGetMaterialTransparency(material));
}


PyObject *py_freyjaGetMaterialBlendSource(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyInt_FromLong(freyjaGetMaterialBlendSource(material));
}


PyObject *py_freyjaGetMaterialBlendDestination(PyObject *self, PyObject *args)
{
	index_t material;

	if (!PyArg_ParseTuple(args, "i", &material))
		return NULL;

	return PyInt_FromLong(freyjaGetMaterialBlendDestination(material));
}


PyObject *py_freyjaMaterialName(PyObject *self, PyObject *args)
{
	index_t material;
	char* name;

	if (!PyArg_ParseTuple(args, "is", &material, &name))
		return NULL;

	freyjaMaterialName(material, name);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialClearFlag(PyObject *self, PyObject *args)
{
	index_t material;
	uint32 flag;

	if (!PyArg_ParseTuple(args, "ii", &material, &flag))
		return NULL;

	freyjaMaterialClearFlag(material, flag);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialSetFlag(PyObject *self, PyObject *args)
{
	index_t material;
	uint32 flag;

	if (!PyArg_ParseTuple(args, "ii", &material, &flag))
		return NULL;

	freyjaMaterialSetFlag(material, flag);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialFlags(PyObject *self, PyObject *args)
{
	index_t material;
	uint32 flags;

	if (!PyArg_ParseTuple(args, "ii", &material, &flags))
		return NULL;

	freyjaMaterialFlags(material, flags);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialTextureName(PyObject *self, PyObject *args)
{
	index_t material;
	char* name;

	if (!PyArg_ParseTuple(args, "is", &material, &name))
		return NULL;

	freyjaMaterialTextureName(material, name);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialTexture(PyObject *self, PyObject *args)
{
	index_t material;
	index_t textureIndex;

	if (!PyArg_ParseTuple(args, "ii", &material, &textureIndex))
		return NULL;

	freyjaMaterialTexture(material, textureIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialAmbient(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t ambient;

	if (!PyArg_ParseTuple(args, "iffff", &material, ambient+0, ambient+1, ambient+2, ambient+3))
		return NULL;

	freyjaMaterialAmbient(material, ambient);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialDiffuse(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t diffuse;

	if (!PyArg_ParseTuple(args, "iffff", &material, diffuse+0, diffuse+1, diffuse+2, diffuse+3))
		return NULL;

	freyjaMaterialDiffuse(material, diffuse);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialSpecular(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t specular;

	if (!PyArg_ParseTuple(args, "iffff", &material, specular+0, specular+1, specular+2, specular+3))
		return NULL;

	freyjaMaterialSpecular(material, specular);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialEmissive(PyObject *self, PyObject *args)
{
	index_t material;
	vec4_t emissive;

	if (!PyArg_ParseTuple(args, "iffff", &material, emissive+0, emissive+1, emissive+2, emissive+3))
		return NULL;

	freyjaMaterialEmissive(material, emissive);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialShininess(PyObject *self, PyObject *args)
{
	index_t material;
	vec_t exponent;

	if (!PyArg_ParseTuple(args, "if", &material, &exponent))
		return NULL;

	freyjaMaterialShininess(material, exponent);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialTransparency(PyObject *self, PyObject *args)
{
	index_t material;
	vec_t transparency;

	if (!PyArg_ParseTuple(args, "if", &material, &transparency))
		return NULL;

	freyjaMaterialTransparency(material, transparency);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialBlendSource(PyObject *self, PyObject *args)
{
	index_t material;
	uint32 factor;

	if (!PyArg_ParseTuple(args, "ii", &material, &factor))
		return NULL;

	freyjaMaterialBlendSource(material, factor);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMaterialBlendDestination(PyObject *self, PyObject *args)
{
	index_t material;
	uint32 factor;

	if (!PyArg_ParseTuple(args, "ii", &material, &factor))
		return NULL;

	freyjaMaterialBlendDestination(material, factor);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaPakBegin(PyObject *self, PyObject *args)
{
	char* filename;

	if (!PyArg_ParseTuple(args, "s", &filename))
		return NULL;

	freyjaPakBegin(filename);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaPakAddDecoderFunction2s(PyObject *self, PyObject *args)
{
	char* module;
	char* symbol;

	if (!PyArg_ParseTuple(args, "ss", &module, &symbol))
		return NULL;

	freyjaPakAddDecoderFunction2s(module, symbol);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaPakAddFullPathFile(PyObject *self, PyObject *args)
{
	index_t pakIndex;
	char* vfsFilename;
	int32 offset;
	int32 size;

	if (!PyArg_ParseTuple(args, "isii", &pakIndex, &vfsFilename, &offset, &size))
		return NULL;

	freyjaPakAddFullPathFile(pakIndex, vfsFilename, offset, size);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaPakEnd(PyObject *self, PyObject *args)
{
	index_t pakIndex;

	if (!PyArg_ParseTuple(args, "i", &pakIndex))
		return NULL;

	freyjaPakEnd(pakIndex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshCreate(PyObject *self, PyObject *args)
{
	freyjaMeshCreate();
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshCopy(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaMeshCopy(mesh));
}


PyObject *py_freyjaMeshDelete(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshDelete(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshMaterial(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t material;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &material))
		return NULL;

	freyjaMeshMaterial(mesh, material);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPosition(PyObject *self, PyObject *args)
{
	index_t meshIndex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "ifff", &meshIndex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaMeshPosition(meshIndex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshName1s(PyObject *self, PyObject *args)
{
	index_t meshIndex;
	char* name;

	if (!PyArg_ParseTuple(args, "is", &meshIndex, &name))
		return NULL;

	freyjaMeshName1s(meshIndex, name);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshFlags1u(PyObject *self, PyObject *args)
{
	uint32 flags;

	if (!PyArg_ParseTuple(args, "i", &flags))
		return NULL;

	freyjaMeshFlags1u(flags);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshTransform3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	freyja_transform_action_t action;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &action, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaMeshTransform3fv(mesh, action, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshVertexCreate3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "ifff", &mesh, xyz+0, xyz+1, xyz+2))
		return NULL;

	return PyInt_FromLong(freyjaMeshVertexCreate3fv(mesh, xyz));
}


PyObject *py_freyjaMeshVertexPos3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &vertex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaMeshVertexPos3fv(mesh, vertex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshVertexNormal3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &vertex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaMeshVertexNormal3fv(mesh, vertex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshTexCoordCreate2fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec2_t uv;

	if (!PyArg_ParseTuple(args, "iff", &mesh, uv+0, uv+1))
		return NULL;

	return PyInt_FromLong(freyjaMeshTexCoordCreate2fv(mesh, uv));
}


PyObject *py_freyjaMeshTexCoordCreate2f(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec_t u;
	vec_t v;

	if (!PyArg_ParseTuple(args, "iff", &mesh, &u, &v))
		return NULL;

	return PyInt_FromLong(freyjaMeshTexCoordCreate2f(mesh, u, v));
}


PyObject *py_freyjaMeshTexCoordCreate3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec3_t uvw;

	if (!PyArg_ParseTuple(args, "ifff", &mesh, uvw+0, uvw+1, uvw+2))
		return NULL;

	return PyInt_FromLong(freyjaMeshTexCoordCreate3fv(mesh, uvw));
}


PyObject *py_freyjaMeshTexCoordCreate3f(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec_t u;
	vec_t v;
	vec_t w;

	if (!PyArg_ParseTuple(args, "ifff", &mesh, &u, &v, &w))
		return NULL;

	return PyInt_FromLong(freyjaMeshTexCoordCreate3f(mesh, u, v, w));
}


PyObject *py_freyjaMeshTexCoord2fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t texcoord;
	vec2_t uv;

	if (!PyArg_ParseTuple(args, "iiff", &mesh, &texcoord, uv+0, uv+1))
		return NULL;

	freyjaMeshTexCoord2fv(mesh, texcoord, uv);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshVertexTexCoord3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t texcoord;
	vec3_t uvw;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &texcoord, uvw+0, uvw+1, uvw+2))
		return NULL;

	freyjaMeshVertexTexCoord3fv(mesh, texcoord, uvw);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshClampTexCoords(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshClampTexCoords(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonCreate(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaMeshPolygonCreate(mesh));
}


PyObject *py_freyjaMeshPolygonDelete(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	freyjaMeshPolygonDelete(mesh, polygon);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonAddVertex1i(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;
	index_t vertex;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &polygon, &vertex))
		return NULL;

	freyjaMeshPolygonAddVertex1i(mesh, polygon, vertex);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonAddTexCoord1i(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;
	index_t texcoord;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &polygon, &texcoord))
		return NULL;

	freyjaMeshPolygonAddTexCoord1i(mesh, polygon, texcoord);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonMaterial(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;
	index_t material;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &polygon, &material))
		return NULL;

	freyjaMeshPolygonMaterial(mesh, polygon, material);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonClearFlag1u(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t face;
	byte flag;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &face, &flag))
		return NULL;

	freyjaMeshPolygonClearFlag1u(mesh, face, flag);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonSetFlag1u(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t face;
	byte flag;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &face, &flag))
		return NULL;

	freyjaMeshPolygonSetFlag1u(mesh, face, flag);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonGroup1u(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t face;
	uint32 group;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &face, &group))
		return NULL;

	freyjaMeshPolygonGroup1u(mesh, face, group);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshUVMapPlanar(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshUVMapPlanar(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshUVMapSpherical(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshUVMapSpherical(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshUVMapCylindrical(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshUVMapCylindrical(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshTesselateTriangles(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshTesselateTriangles(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshNormalFlip(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshNormalFlip(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshGenerateVertexNormals(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	freyjaMeshGenerateVertexNormals(mesh);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonExtrudeQuad1f(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t quad;
	vec3_t n;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &quad, n+0, n+1, n+2))
		return NULL;

	freyjaMeshPolygonExtrudeQuad1f(mesh, quad, n);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshVertexWeight(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;
	index_t bone;
	vec_t weight;

	if (!PyArg_ParseTuple(args, "iiif", &mesh, &vertex, &bone, &weight))
		return NULL;

	freyjaMeshVertexWeight(mesh, vertex, bone, weight);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshTexCoordWeld(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t a;
	index_t b;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &a, &b))
		return NULL;

	return PyInt_FromLong(freyjaMeshTexCoordWeld(mesh, a, b));
}


PyObject *py_freyjaMeshVertexWeld(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t a;
	index_t b;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &a, &b))
		return NULL;

	return PyInt_FromLong(freyjaMeshVertexWeld(mesh, a, b));
}


PyObject *py_freyjaMeshUpdateBlendVertices(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t track;
	vec_t time;

	if (!PyArg_ParseTuple(args, "iif", &mesh, &track, &time))
		return NULL;

	freyjaMeshUpdateBlendVertices(mesh, track, time);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshVertexTrackNew(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec_t duration;
	vec_t rate;

	if (!PyArg_ParseTuple(args, "iff", &mesh, &duration, &rate))
		return NULL;

	return PyInt_FromLong(freyjaMeshVertexTrackNew(mesh, duration, rate));
}


PyObject *py_freyjaMeshVertexKeyFrameNew(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t track;
	vec_t time;

	if (!PyArg_ParseTuple(args, "iif", &mesh, &track, &time))
		return NULL;

	return PyInt_FromLong(freyjaMeshVertexKeyFrameNew(mesh, track, time));
}


PyObject *py_freyjaMeshVertexKeyFrame3f(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t track;
	index_t key;
	uint32 vert;
	vec_t x;
	vec_t y;
	vec_t z;

	if (!PyArg_ParseTuple(args, "iiiifff", &mesh, &track, &key, &vert, &x, &y, &z))
		return NULL;

	freyjaMeshVertexKeyFrame3f(mesh, track, key, vert, x, y, z);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaMeshPolygonSplit(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	freyjaMeshPolygonSplit(mesh, polygon);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshCount(PyObject *self, PyObject *args)
{
	return PyInt_FromLong(freyjaGetMeshCount());
}


PyObject *py_freyjaGetMeshBoundingBox(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec3_t min;
	vec3_t max;

	if (!PyArg_ParseTuple(args, "iffffff", &mesh, min+0, min+1, min+2, max+0, max+1, max+2))
		return NULL;

	freyjaGetMeshBoundingBox(mesh, min, max);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshBoundingSphere(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec3_t origin;
	vec_t radius;

	if (!PyArg_ParseTuple(args, "iffff", &mesh, origin+0, origin+1, origin+2, &radius))
		return NULL;

	freyjaGetMeshBoundingSphere(mesh, origin, radius);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshFlags(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshFlags(mesh));
}


PyObject *py_freyjaGetMeshPosition(PyObject *self, PyObject *args)
{
	index_t mesh;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "ifff", &mesh, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaGetMeshPosition(mesh, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshNameString(PyObject *self, PyObject *args)
{
	index_t meshIndex;

	if (!PyArg_ParseTuple(args, "i", &meshIndex))
		return NULL;

	return PyString_FromString(freyjaGetMeshNameString(meshIndex));
}


PyObject *py_freyjaGetMeshVertexFlags(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &vertex))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexFlags(mesh, vertex));
}


PyObject *py_freyjaGetMeshVertexPos3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &vertex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaGetMeshVertexPos3fv(mesh, vertex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshVertexNormal3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &vertex, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaGetMeshVertexNormal3fv(mesh, vertex, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshVertexTexCoord3fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vert;
	vec3_t xyz;

	if (!PyArg_ParseTuple(args, "iifff", &mesh, &vert, xyz+0, xyz+1, xyz+2))
		return NULL;

	freyjaGetMeshVertexTexCoord3fv(mesh, vert, xyz);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshVertexTexCoord(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &vertex))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexTexCoord(mesh, vertex));
}


PyObject *py_freyjaGetMeshVertexPolygonRefCount(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &vertex))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexPolygonRefCount(mesh, vertex));
}


PyObject *py_freyjaGetMeshVertexPolygonRefIndex(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t vertex;
	uint32 element;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &vertex, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexPolygonRefIndex(mesh, vertex, element));
}


PyObject *py_freyjaGetMeshTexCoord2fv(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t texcoord;
	vec2_t uv;

	if (!PyArg_ParseTuple(args, "iiff", &mesh, &texcoord, uv+0, uv+1))
		return NULL;

	freyjaGetMeshTexCoord2fv(mesh, texcoord, uv);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshPolygonFlags(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonFlags(mesh, polygon));
}


PyObject *py_freyjaGetMeshPolygonGroup(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonGroup(mesh, polygon));
}


PyObject *py_freyjaGetMeshPolygonEdgeCount(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonEdgeCount(mesh, polygon));
}


PyObject *py_freyjaGetMeshPolygonVertexCount(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonVertexCount(mesh, polygon));
}


PyObject *py_freyjaGetMeshPolygonVertexIndex(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;
	uint32 element;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &polygon, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonVertexIndex(mesh, polygon, element));
}


PyObject *py_freyjaGetMeshPolygonTexCoordCount(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonTexCoordCount(mesh, polygon));
}


PyObject *py_freyjaGetMeshPolygonTexCoordIndex(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;
	uint32 element;

	if (!PyArg_ParseTuple(args, "iii", &mesh, &polygon, &element))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonTexCoordIndex(mesh, polygon, element));
}


PyObject *py_freyjaGetMeshPolygonMaterial(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t polygon;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &polygon))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonMaterial(mesh, polygon));
}


PyObject *py_freyjaGetMeshTexCoordCount(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshTexCoordCount(mesh));
}


PyObject *py_freyjaGetMeshVertexCount(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexCount(mesh));
}


PyObject *py_freyjaGetMeshNormalCount(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshNormalCount(mesh));
}


PyObject *py_freyjaGetMeshPolygonCount(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshPolygonCount(mesh));
}


PyObject *py_freyjaGetMeshBlendVertices(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

#if FIXME
	/* No support for returning pointers yet... */
	return PyFloat_FromDouble(freyjaGetMeshBlendVertices(mesh));
#endif // FIXME

	return NULL;
}


PyObject *py_freyjaGetMeshWeight(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t weight;
	index_t vertex;
	index_t bone;
	vec_t weightv;

	if (!PyArg_ParseTuple(args, "iiiif", &mesh, &weight, &vertex, &bone, &weightv))
		return NULL;

	freyjaGetMeshWeight(mesh, weight, &vertex, &bone, &weightv);
	return PyInt_FromLong(0);
}


PyObject *py_freyjaGetMeshWeightCount(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshWeightCount(mesh));
}


PyObject *py_freyjaGetMeshVertexTrackCount(PyObject *self, PyObject *args)
{
	index_t mesh;

	if (!PyArg_ParseTuple(args, "i", &mesh))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexTrackCount(mesh));
}


PyObject *py_freyjaGetMeshVertexKeyFrameCount(PyObject *self, PyObject *args)
{
	index_t mesh;
	index_t track;

	if (!PyArg_ParseTuple(args, "ii", &mesh, &track))
		return NULL;

	return PyInt_FromLong(freyjaGetMeshVertexKeyFrameCount(mesh, track));
}


PyObject *py_freyjaMeshCreateSheet(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t size;
	uint32 rows;
	uint32 columns;

	if (!PyArg_ParseTuple(args, "ffffii", origin+0, origin+1, origin+2, &size, &rows, &columns))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateSheet(origin, size, rows, columns));
}


PyObject *py_freyjaMeshCreateCube(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t size;

	if (!PyArg_ParseTuple(args, "ffff", origin+0, origin+1, origin+2, &size))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateCube(origin, size));
}


PyObject *py_freyjaMeshCreateCircle(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t radius;
	uint32 count;

	if (!PyArg_ParseTuple(args, "ffffi", origin+0, origin+1, origin+2, &radius, &count))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateCircle(origin, radius, count));
}


PyObject *py_freyjaMeshCreateCone(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t height;
	vec_t radius;
	uint32 wedges;

	if (!PyArg_ParseTuple(args, "fffffi", origin+0, origin+1, origin+2, &height, &radius, &wedges))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateCone(origin, height, radius, wedges));
}


PyObject *py_freyjaMeshCreateCylinder(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t height;
	vec_t radius;
	uint32 sides;
	uint32 rings;

	if (!PyArg_ParseTuple(args, "fffffii", origin+0, origin+1, origin+2, &height, &radius, &sides, &rings))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateCylinder(origin, height, radius, sides, rings));
}


PyObject *py_freyjaMeshCreateSphere(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t radius;
	int32 sides;
	int32 rings;

	if (!PyArg_ParseTuple(args, "ffffii", origin+0, origin+1, origin+2, &radius, &sides, &rings))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateSphere(origin, radius, sides, rings));
}


PyObject *py_freyjaMeshCreateTube(PyObject *self, PyObject *args)
{
	vec3_t origin;
	vec_t height;
	vec_t radius;
	int32 sides;
	int32 rings;

	if (!PyArg_ParseTuple(args, "fffffii", origin+0, origin+1, origin+2, &height, &radius, &sides, &rings))
		return NULL;

	return PyInt_FromLong(freyjaMeshCreateTube(origin, height, radius, sides, rings));
}


PyMethodDef Plugin_methods[] = {
	{ "freyjaSkeletonCreate", py_freyjaSkeletonCreate, METH_VARARGS },
	{ "freyjaSkeletonPoolClear", py_freyjaSkeletonPoolClear, METH_VARARGS },
	{ "freyjaSkeletonDelete", py_freyjaSkeletonDelete, METH_VARARGS },
	{ "freyjaSkeletonUpdateBones", py_freyjaSkeletonUpdateBones, METH_VARARGS },
	{ "freyjaSkeletonAddBone", py_freyjaSkeletonAddBone, METH_VARARGS },
	{ "freyjaSkeletonRootIndex", py_freyjaSkeletonRootIndex, METH_VARARGS },
	{ "freyjaSkeletonTransform", py_freyjaSkeletonTransform, METH_VARARGS },
	{ "freyjaGetSkeletonCount", py_freyjaGetSkeletonCount, METH_VARARGS },
	{ "freyjaGetSkeletonBoneCount", py_freyjaGetSkeletonBoneCount, METH_VARARGS },
	{ "freyjaGetSkeletonBoneIndex", py_freyjaGetSkeletonBoneIndex, METH_VARARGS },
	{ "freyjaGetSkeletonRootIndex", py_freyjaGetSkeletonRootIndex, METH_VARARGS },
	{ "freyjaSkeletonName", py_freyjaSkeletonName, METH_VARARGS },
	{ "freyjaGetSkeletonName", py_freyjaGetSkeletonName, METH_VARARGS },
	{ "freyjaPython1s", py_freyjaPython1s, METH_VARARGS },
	{ "freyjaTextureCreateFilename", py_freyjaTextureCreateFilename, METH_VARARGS },
	{ "freyjaTextureCreateBuffer", py_freyjaTextureCreateBuffer, METH_VARARGS },
	{ "freyjaTextureDelete", py_freyjaTextureDelete, METH_VARARGS },
	{ "freyjaGetTextureImage", py_freyjaGetTextureImage, METH_VARARGS },
	{ "freyjaGetTexturePoolCount", py_freyjaGetTexturePoolCount, METH_VARARGS },
	{ "freyjaGetTextureCount", py_freyjaGetTextureCount, METH_VARARGS },
	{ "freyjaGetModelCount", py_freyjaGetModelCount, METH_VARARGS },
	{ "freyjaModelCreate", py_freyjaModelCreate, METH_VARARGS },
	{ "freyjaModelAddSkeleton", py_freyjaModelAddSkeleton, METH_VARARGS },
	{ "freyjaModelAddMesh", py_freyjaModelAddMesh, METH_VARARGS },
	{ "freyjaGetModelFlags", py_freyjaGetModelFlags, METH_VARARGS },
	{ "freyjaGetModelMeshCount", py_freyjaGetModelMeshCount, METH_VARARGS },
	{ "freyjaGetModelMeshIndex", py_freyjaGetModelMeshIndex, METH_VARARGS },
	{ "freyjaGetModelSkeleton", py_freyjaGetModelSkeleton, METH_VARARGS },
	{ "freyjaModelTransform", py_freyjaModelTransform, METH_VARARGS },
	{ "freyjaModelClear", py_freyjaModelClear, METH_VARARGS },
	{ "freyjaGetBoneCount", py_freyjaGetBoneCount, METH_VARARGS },
	{ "freyjaBonePoolClear", py_freyjaBonePoolClear, METH_VARARGS },
	{ "freyjaBoneCreate", py_freyjaBoneCreate, METH_VARARGS },
	{ "freyjaBoneDelete", py_freyjaBoneDelete, METH_VARARGS },
	{ "freyjaBoneFlags", py_freyjaBoneFlags, METH_VARARGS },
	{ "freyjaBoneParent", py_freyjaBoneParent, METH_VARARGS },
	{ "freyjaBoneName", py_freyjaBoneName, METH_VARARGS },
	{ "freyjaBoneRemoveChild", py_freyjaBoneRemoveChild, METH_VARARGS },
	{ "freyjaBoneAddChild", py_freyjaBoneAddChild, METH_VARARGS },
	{ "freyjaBoneTranslate3f", py_freyjaBoneTranslate3f, METH_VARARGS },
	{ "freyjaBoneTranslate3fv", py_freyjaBoneTranslate3fv, METH_VARARGS },
	{ "freyjaBoneRotateEuler3f", py_freyjaBoneRotateEuler3f, METH_VARARGS },
	{ "freyjaBoneRotateEuler3fv", py_freyjaBoneRotateEuler3fv, METH_VARARGS },
	{ "freyjaBoneRotateQuat4f", py_freyjaBoneRotateQuat4f, METH_VARARGS },
	{ "freyjaBoneRotateQuat4fv", py_freyjaBoneRotateQuat4fv, METH_VARARGS },
	{ "freyjaGetBoneRotationQuat4fv", py_freyjaGetBoneRotationQuat4fv, METH_VARARGS },
	{ "freyjaGetBoneRotationEuler3fv", py_freyjaGetBoneRotationEuler3fv, METH_VARARGS },
	{ "freyjaBoneTransform", py_freyjaBoneTransform, METH_VARARGS },
	{ "freyjaBoneTransform3fv", py_freyjaBoneTransform3fv, METH_VARARGS },
	{ "freyjaGetBoneNameString", py_freyjaGetBoneNameString, METH_VARARGS },
	{ "freyjaGetBoneName", py_freyjaGetBoneName, METH_VARARGS },
	{ "freyjaGetBoneParent", py_freyjaGetBoneParent, METH_VARARGS },
	{ "freyjaGetBoneBindPose16fv", py_freyjaGetBoneBindPose16fv, METH_VARARGS },
	{ "freyjaGetBoneWorldPos3fv", py_freyjaGetBoneWorldPos3fv, METH_VARARGS },
	{ "freyjaGetBoneTranslation3fv", py_freyjaGetBoneTranslation3fv, METH_VARARGS },
	{ "freyjaGetBoneSkeletonIndex", py_freyjaGetBoneSkeletonIndex, METH_VARARGS },
	{ "freyjaGetBoneChild", py_freyjaGetBoneChild, METH_VARARGS },
	{ "freyjaGetBoneChildCount", py_freyjaGetBoneChildCount, METH_VARARGS },
	{ "freyjaBoneUpdateBindPose", py_freyjaBoneUpdateBindPose, METH_VARARGS },
	{ "freyjaBoneGetBindTransform", py_freyjaBoneGetBindTransform, METH_VARARGS },
	{ "freyjaBoneGetBindTransformInverse", py_freyjaBoneGetBindTransformInverse, METH_VARARGS },
	{ "freyjaBoneBindTransformVertex", py_freyjaBoneBindTransformVertex, METH_VARARGS },
	{ "freyjaBoneTrackNew", py_freyjaBoneTrackNew, METH_VARARGS },
	{ "freyjaBoneTrackDuration", py_freyjaBoneTrackDuration, METH_VARARGS },
	{ "freyjaBoneTrackRate", py_freyjaBoneTrackRate, METH_VARARGS },
	{ "freyjaBoneKeyFrameNew", py_freyjaBoneKeyFrameNew, METH_VARARGS },
	{ "freyjaBonePosKeyFrame3f", py_freyjaBonePosKeyFrame3f, METH_VARARGS },
	{ "freyjaBoneRotKeyFrameEuler3f", py_freyjaBoneRotKeyFrameEuler3f, METH_VARARGS },
	{ "freyjaBoneRotKeyFrameQuat4f", py_freyjaBoneRotKeyFrameQuat4f, METH_VARARGS },
	{ "freyjaLightCreate", py_freyjaLightCreate, METH_VARARGS },
	{ "freyjaGetLightCount", py_freyjaGetLightCount, METH_VARARGS },
	{ "freyjaLightDelete", py_freyjaLightDelete, METH_VARARGS },
	{ "freyjaLightPosition4v", py_freyjaLightPosition4v, METH_VARARGS },
	{ "freyjaLightAmbient", py_freyjaLightAmbient, METH_VARARGS },
	{ "freyjaLightDiffuse", py_freyjaLightDiffuse, METH_VARARGS },
	{ "freyjaLightSpecular", py_freyjaLightSpecular, METH_VARARGS },
	{ "freyjaGetLightPosition4v", py_freyjaGetLightPosition4v, METH_VARARGS },
	{ "freyjaGetLightAmbient", py_freyjaGetLightAmbient, METH_VARARGS },
	{ "freyjaGetLightDiffuse", py_freyjaGetLightDiffuse, METH_VARARGS },
	{ "freyjaGetLightSpecular", py_freyjaGetLightSpecular, METH_VARARGS },
	{ "freyjaMaterialCreate", py_freyjaMaterialCreate, METH_VARARGS },
	{ "freyjaMaterialClearAll", py_freyjaMaterialClearAll, METH_VARARGS },
	{ "freyjaGetMaterialCount", py_freyjaGetMaterialCount, METH_VARARGS },
	{ "freyjaGetMaterialIndex", py_freyjaGetMaterialIndex, METH_VARARGS },
	{ "freyjaGetMaterialName", py_freyjaGetMaterialName, METH_VARARGS },
	{ "freyjaGetMaterialFlags", py_freyjaGetMaterialFlags, METH_VARARGS },
	{ "freyjaGetMaterialTexture", py_freyjaGetMaterialTexture, METH_VARARGS },
	{ "freyjaGetMaterialTextureName", py_freyjaGetMaterialTextureName, METH_VARARGS },
	{ "freyjaGetMaterialAmbient", py_freyjaGetMaterialAmbient, METH_VARARGS },
	{ "freyjaGetMaterialDiffuse", py_freyjaGetMaterialDiffuse, METH_VARARGS },
	{ "freyjaGetMaterialSpecular", py_freyjaGetMaterialSpecular, METH_VARARGS },
	{ "freyjaGetMaterialEmissive", py_freyjaGetMaterialEmissive, METH_VARARGS },
	{ "freyjaGetMaterialShininess", py_freyjaGetMaterialShininess, METH_VARARGS },
	{ "freyjaGetMaterialTransparency", py_freyjaGetMaterialTransparency, METH_VARARGS },
	{ "freyjaGetMaterialBlendSource", py_freyjaGetMaterialBlendSource, METH_VARARGS },
	{ "freyjaGetMaterialBlendDestination", py_freyjaGetMaterialBlendDestination, METH_VARARGS },
	{ "freyjaMaterialName", py_freyjaMaterialName, METH_VARARGS },
	{ "freyjaMaterialClearFlag", py_freyjaMaterialClearFlag, METH_VARARGS },
	{ "freyjaMaterialSetFlag", py_freyjaMaterialSetFlag, METH_VARARGS },
	{ "freyjaMaterialFlags", py_freyjaMaterialFlags, METH_VARARGS },
	{ "freyjaMaterialTextureName", py_freyjaMaterialTextureName, METH_VARARGS },
	{ "freyjaMaterialTexture", py_freyjaMaterialTexture, METH_VARARGS },
	{ "freyjaMaterialAmbient", py_freyjaMaterialAmbient, METH_VARARGS },
	{ "freyjaMaterialDiffuse", py_freyjaMaterialDiffuse, METH_VARARGS },
	{ "freyjaMaterialSpecular", py_freyjaMaterialSpecular, METH_VARARGS },
	{ "freyjaMaterialEmissive", py_freyjaMaterialEmissive, METH_VARARGS },
	{ "freyjaMaterialShininess", py_freyjaMaterialShininess, METH_VARARGS },
	{ "freyjaMaterialTransparency", py_freyjaMaterialTransparency, METH_VARARGS },
	{ "freyjaMaterialBlendSource", py_freyjaMaterialBlendSource, METH_VARARGS },
	{ "freyjaMaterialBlendDestination", py_freyjaMaterialBlendDestination, METH_VARARGS },
	{ "freyjaPakBegin", py_freyjaPakBegin, METH_VARARGS },
	{ "freyjaPakAddDecoderFunction2s", py_freyjaPakAddDecoderFunction2s, METH_VARARGS },
	{ "freyjaPakAddFullPathFile", py_freyjaPakAddFullPathFile, METH_VARARGS },
	{ "freyjaPakEnd", py_freyjaPakEnd, METH_VARARGS },
	{ "freyjaMeshCreate", py_freyjaMeshCreate, METH_VARARGS },
	{ "freyjaMeshCopy", py_freyjaMeshCopy, METH_VARARGS },
	{ "freyjaMeshDelete", py_freyjaMeshDelete, METH_VARARGS },
	{ "freyjaMeshMaterial", py_freyjaMeshMaterial, METH_VARARGS },
	{ "freyjaMeshPosition", py_freyjaMeshPosition, METH_VARARGS },
	{ "freyjaMeshName1s", py_freyjaMeshName1s, METH_VARARGS },
	{ "freyjaMeshFlags1u", py_freyjaMeshFlags1u, METH_VARARGS },
	{ "freyjaMeshTransform3fv", py_freyjaMeshTransform3fv, METH_VARARGS },
	{ "freyjaMeshVertexCreate3fv", py_freyjaMeshVertexCreate3fv, METH_VARARGS },
	{ "freyjaMeshVertexPos3fv", py_freyjaMeshVertexPos3fv, METH_VARARGS },
	{ "freyjaMeshVertexNormal3fv", py_freyjaMeshVertexNormal3fv, METH_VARARGS },
	{ "freyjaMeshTexCoordCreate2fv", py_freyjaMeshTexCoordCreate2fv, METH_VARARGS },
	{ "freyjaMeshTexCoordCreate2f", py_freyjaMeshTexCoordCreate2f, METH_VARARGS },
	{ "freyjaMeshTexCoordCreate3fv", py_freyjaMeshTexCoordCreate3fv, METH_VARARGS },
	{ "freyjaMeshTexCoordCreate3f", py_freyjaMeshTexCoordCreate3f, METH_VARARGS },
	{ "freyjaMeshTexCoord2fv", py_freyjaMeshTexCoord2fv, METH_VARARGS },
	{ "freyjaMeshVertexTexCoord3fv", py_freyjaMeshVertexTexCoord3fv, METH_VARARGS },
	{ "freyjaMeshClampTexCoords", py_freyjaMeshClampTexCoords, METH_VARARGS },
	{ "freyjaMeshPolygonCreate", py_freyjaMeshPolygonCreate, METH_VARARGS },
	{ "freyjaMeshPolygonDelete", py_freyjaMeshPolygonDelete, METH_VARARGS },
	{ "freyjaMeshPolygonAddVertex1i", py_freyjaMeshPolygonAddVertex1i, METH_VARARGS },
	{ "freyjaMeshPolygonAddTexCoord1i", py_freyjaMeshPolygonAddTexCoord1i, METH_VARARGS },
	{ "freyjaMeshPolygonMaterial", py_freyjaMeshPolygonMaterial, METH_VARARGS },
	{ "freyjaMeshPolygonClearFlag1u", py_freyjaMeshPolygonClearFlag1u, METH_VARARGS },
	{ "freyjaMeshPolygonSetFlag1u", py_freyjaMeshPolygonSetFlag1u, METH_VARARGS },
	{ "freyjaMeshPolygonGroup1u", py_freyjaMeshPolygonGroup1u, METH_VARARGS },
	{ "freyjaMeshUVMapPlanar", py_freyjaMeshUVMapPlanar, METH_VARARGS },
	{ "freyjaMeshUVMapSpherical", py_freyjaMeshUVMapSpherical, METH_VARARGS },
	{ "freyjaMeshUVMapCylindrical", py_freyjaMeshUVMapCylindrical, METH_VARARGS },
	{ "freyjaMeshTesselateTriangles", py_freyjaMeshTesselateTriangles, METH_VARARGS },
	{ "freyjaMeshNormalFlip", py_freyjaMeshNormalFlip, METH_VARARGS },
	{ "freyjaMeshGenerateVertexNormals", py_freyjaMeshGenerateVertexNormals, METH_VARARGS },
	{ "freyjaMeshPolygonExtrudeQuad1f", py_freyjaMeshPolygonExtrudeQuad1f, METH_VARARGS },
	{ "freyjaMeshVertexWeight", py_freyjaMeshVertexWeight, METH_VARARGS },
	{ "freyjaMeshTexCoordWeld", py_freyjaMeshTexCoordWeld, METH_VARARGS },
	{ "freyjaMeshVertexWeld", py_freyjaMeshVertexWeld, METH_VARARGS },
	{ "freyjaMeshUpdateBlendVertices", py_freyjaMeshUpdateBlendVertices, METH_VARARGS },
	{ "freyjaMeshVertexTrackNew", py_freyjaMeshVertexTrackNew, METH_VARARGS },
	{ "freyjaMeshVertexKeyFrameNew", py_freyjaMeshVertexKeyFrameNew, METH_VARARGS },
	{ "freyjaMeshVertexKeyFrame3f", py_freyjaMeshVertexKeyFrame3f, METH_VARARGS },
	{ "freyjaMeshPolygonSplit", py_freyjaMeshPolygonSplit, METH_VARARGS },
	{ "freyjaGetMeshCount", py_freyjaGetMeshCount, METH_VARARGS },
	{ "freyjaGetMeshBoundingBox", py_freyjaGetMeshBoundingBox, METH_VARARGS },
	{ "freyjaGetMeshBoundingSphere", py_freyjaGetMeshBoundingSphere, METH_VARARGS },
	{ "freyjaGetMeshFlags", py_freyjaGetMeshFlags, METH_VARARGS },
	{ "freyjaGetMeshPosition", py_freyjaGetMeshPosition, METH_VARARGS },
	{ "freyjaGetMeshNameString", py_freyjaGetMeshNameString, METH_VARARGS },
	{ "freyjaGetMeshVertexFlags", py_freyjaGetMeshVertexFlags, METH_VARARGS },
	{ "freyjaGetMeshVertexPos3fv", py_freyjaGetMeshVertexPos3fv, METH_VARARGS },
	{ "freyjaGetMeshVertexNormal3fv", py_freyjaGetMeshVertexNormal3fv, METH_VARARGS },
	{ "freyjaGetMeshVertexTexCoord3fv", py_freyjaGetMeshVertexTexCoord3fv, METH_VARARGS },
	{ "freyjaGetMeshVertexTexCoord", py_freyjaGetMeshVertexTexCoord, METH_VARARGS },
	{ "freyjaGetMeshVertexPolygonRefCount", py_freyjaGetMeshVertexPolygonRefCount, METH_VARARGS },
	{ "freyjaGetMeshVertexPolygonRefIndex", py_freyjaGetMeshVertexPolygonRefIndex, METH_VARARGS },
	{ "freyjaGetMeshTexCoord2fv", py_freyjaGetMeshTexCoord2fv, METH_VARARGS },
	{ "freyjaGetMeshPolygonFlags", py_freyjaGetMeshPolygonFlags, METH_VARARGS },
	{ "freyjaGetMeshPolygonGroup", py_freyjaGetMeshPolygonGroup, METH_VARARGS },
	{ "freyjaGetMeshPolygonEdgeCount", py_freyjaGetMeshPolygonEdgeCount, METH_VARARGS },
	{ "freyjaGetMeshPolygonVertexCount", py_freyjaGetMeshPolygonVertexCount, METH_VARARGS },
	{ "freyjaGetMeshPolygonVertexIndex", py_freyjaGetMeshPolygonVertexIndex, METH_VARARGS },
	{ "freyjaGetMeshPolygonTexCoordCount", py_freyjaGetMeshPolygonTexCoordCount, METH_VARARGS },
	{ "freyjaGetMeshPolygonTexCoordIndex", py_freyjaGetMeshPolygonTexCoordIndex, METH_VARARGS },
	{ "freyjaGetMeshPolygonMaterial", py_freyjaGetMeshPolygonMaterial, METH_VARARGS },
	{ "freyjaGetMeshTexCoordCount", py_freyjaGetMeshTexCoordCount, METH_VARARGS },
	{ "freyjaGetMeshVertexCount", py_freyjaGetMeshVertexCount, METH_VARARGS },
	{ "freyjaGetMeshNormalCount", py_freyjaGetMeshNormalCount, METH_VARARGS },
	{ "freyjaGetMeshPolygonCount", py_freyjaGetMeshPolygonCount, METH_VARARGS },
	{ "freyjaGetMeshBlendVertices", py_freyjaGetMeshBlendVertices, METH_VARARGS },
	{ "freyjaGetMeshWeight", py_freyjaGetMeshWeight, METH_VARARGS },
	{ "freyjaGetMeshWeightCount", py_freyjaGetMeshWeightCount, METH_VARARGS },
	{ "freyjaGetMeshVertexTrackCount", py_freyjaGetMeshVertexTrackCount, METH_VARARGS },
	{ "freyjaGetMeshVertexKeyFrameCount", py_freyjaGetMeshVertexKeyFrameCount, METH_VARARGS },
	{ "freyjaMeshCreateSheet", py_freyjaMeshCreateSheet, METH_VARARGS },
	{ "freyjaMeshCreateCube", py_freyjaMeshCreateCube, METH_VARARGS },
	{ "freyjaMeshCreateCircle", py_freyjaMeshCreateCircle, METH_VARARGS },
	{ "freyjaMeshCreateCone", py_freyjaMeshCreateCone, METH_VARARGS },
	{ "freyjaMeshCreateCylinder", py_freyjaMeshCreateCylinder, METH_VARARGS },
	{ "freyjaMeshCreateSphere", py_freyjaMeshCreateSphere, METH_VARARGS },
	{ "freyjaMeshCreateTube", py_freyjaMeshCreateTube, METH_VARARGS },
	{ NULL }
};


PyObject *Freyja_Plugin_Gobals()
{
	PyObject *module, *dict, *tmp;

	module = Py_InitModule("FreyjaModeler", Plugin_methods);
	dict = PyModule_GetDict(module);
	
	/* Append gobal constants you want python to see */
	tmp = PyInt_FromLong(FREYJA_MODEL);
	PyDict_SetItemString(dict, "FREYJA_MODEL", tmp);
	Py_DECREF(tmp);
	
	return module;
}


#endif // USING_PYTHON


void freyjaPython1s(const char *plugin, const char *symbol, const char *s)
{
	if (!plugin || !plugin[0] || !symbol || !symbol[0] || !s || !s[0])
		return;

#ifdef USING_PYTHON
	PyObject *module, *dict, *tmp, *tmp2;

	/* Start up python */
	Py_Initialize();
	module = Freyja_Plugin_Gobals();
	dict = PyModule_GetDict(module);

	/* Append gobal constants, string in as "Symbol" in python */
	tmp = PyString_FromFormat(symbol);
	PyDict_SetItemString(dict, "FreyjaSymbol", tmp);
	Py_DECREF(tmp);
	tmp2 = PyString_FromFormat(s);
	PyDict_SetItemString(dict, "FreyjaArgs", tmp2);
	Py_DECREF(tmp2);

	freyjaPrintMessage("[Module '%s' opened.]", plugin);
	FILE *f = fopen(plugin, "r");

	if (!f)
	{
		freyjaPrintError("[Module '%s' failed to load.]", plugin);
		perror(plugin);
	}
	else
	{
		PyRun_SimpleFile(f, plugin);
		Py_Finalize();
		fclose(f);
	}
#else
	freyjaPrintError("[Module '%s' failed to load.  Rebuild with USING_PYTHON.]", plugin);
#endif // USING_PYTHON
}


