/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/*===========================================================================
 * 
 * Project : freyja
 * Author  : Terry 'Mongoose' Hendrix II
 * Website : http://www.icculus.org/freyja/
 * Email   : mongooseichiban@gmail.com
 * Object  : 
 * License : No use w/o permission (C) 2004-2007 Mongoose
 * Comments: This is the Lua plugin ABI.
 *
 *           This file was generated by Mongoose's UpdateBindings-Lua.py
 *           - Mongoose <mongooseichiban@gmail.com>
 *
 * 2007.6.29:
 * Mongoose - Generated, Based on C ABI for freyja
 ==========================================================================*/

#include "SkeletonABI.h"
#include "TextureABI.h"
#include "ModelABI.h"
#include "BoneABI.h"
#include "LightABI.h"
#include "MaterialABI.h"
#include "PakABI.h"
#include "MeshABI.h"
#include "freyja.h"
#include "LuaABI.h"
#ifdef LUA_FOUND


extern "C" {
#include "lua5.1/lua.h"
#include "lua5.1/lualib.h"
#include "lua5.1/lauxlib.h"
}

#   ifdef LUAWRAPPER_FOUND
#       include "Lua.h"
#   else
#       include "Lua.cpp"
#   endif // LUAWRAPPER_FOUND

Lua gLuaVM;



const Lua &freyjaGetLuaVM()
{
	return gLuaVM;
}


int lua_freyjaSkeletonCreate(lua_State *L)
{
	freyjaSkeletonCreate();
	return 0;
}


int lua_freyjaSkeletonPoolClear(lua_State *L)
{
	freyjaSkeletonPoolClear();
	return 0;
}


int lua_freyjaSkeletonDelete(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	freyjaSkeletonDelete(skeletonIndex);
	return 0;
}


int lua_freyjaSkeletonUpdateBones(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	freyjaSkeletonUpdateBones(skeletonIndex);
	return 0;
}


int lua_freyjaSkeletonAddBone(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	index_t boneIndex = (int)lua_tonumber(L, 2);
	freyjaSkeletonAddBone(skeletonIndex, boneIndex);
	return 0;
}


int lua_freyjaSkeletonRootIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	index_t boneIndex = (int)lua_tonumber(L, 2);
	freyjaSkeletonRootIndex(skeletonIndex, boneIndex);
	return 0;
}


int lua_freyjaSkeletonTransform(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	freyja_transform_action_t action = (freyja_transform_action_t)(int)lua_tonumber(L, 1);
	vec_t x = lua_tonumber(L, 3);
	vec_t y = lua_tonumber(L, 4);
	vec_t z = lua_tonumber(L, 5);
	freyjaSkeletonTransform(boneIndex, action, x, y, z);
	return 0;
}


int lua_freyjaGetSkeletonCount(lua_State *L)
{
	int integer_value = freyjaGetSkeletonCount();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetSkeletonBoneCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetSkeletonBoneCount(skeletonIndex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetSkeletonBoneIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	uint32 element = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetSkeletonBoneIndex(skeletonIndex, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetSkeletonRootIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetSkeletonRootIndex(skeletonIndex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaSkeletonName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t skeleton = (int)lua_tonumber(L, 1);
	const char *name = lua_tostring(L, 2);
	freyjaSkeletonName(skeleton, name);
	return 0;
}


int lua_freyjaGetSkeletonName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t skeleton = (int)lua_tonumber(L, 1);
	const char *string_value = freyjaGetSkeletonName(skeleton);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaTextureCreateFilename(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	const char *filename = lua_tostring(L, 1);
	freyjaTextureCreateFilename(filename);
	return 0;
}


int lua_freyjaTextureCreateBuffer(lua_State *L)
{
#warning "Unsupported function binding."
	freyjaPrintError("Invalid binding %s(), %s:%i", __func__, __FILE__, __LINE__);
#if FIXME
	/* No binding support for this type of method. */
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	byte* image = (int)lua_tonumber(L, 1);
	uint32 byteDepth = (int)lua_tonumber(L, 2);
	uint32 width = (int)lua_tonumber(L, 3);
	uint32 height = (int)lua_tonumber(L, 4);
	freyja_colormode_t type = (freyja_colormode_t)(int)lua_tonumber(L, 4);
	int integer_value = freyjaTextureCreateBuffer(image, byteDepth, width, height, type);
	lua_pushnumber(L, integer_value);
	return 1;
#endif // FIXME

	return 0;
}


int lua_freyjaTextureDelete(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t textureIndex = (int)lua_tonumber(L, 1);
	freyjaTextureDelete(textureIndex);
	return 0;
}


int lua_freyjaGetTextureImage(lua_State *L)
{
#warning "Unsupported function binding."
	freyjaPrintError("Invalid binding %s(), %s:%i", __func__, __FILE__, __LINE__);
#if FIXME
	/* No binding support for this type of method. */
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	index_t textureIndex = (int)lua_tonumber(L, 1);
	uint32 w = (int)lua_tonumber(L, 2);
	uint32 h = (int)lua_tonumber(L, 3);
	uint32 bitDepth = (int)lua_tonumber(L, 4);
	uint32 type = (int)lua_tonumber(L, 5);
	byte* image = (int)lua_tonumber(L, 6);
	freyjaGetTextureImage(textureIndex, w, h, bitDepth, type, image);
	return 0;
#endif // FIXME

	return 0;
}


int lua_freyjaGetTexturePoolCount(lua_State *L)
{
	int integer_value = freyjaGetTexturePoolCount();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetTextureCount(lua_State *L)
{
	int integer_value = freyjaGetTextureCount();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetModelCount(lua_State *L)
{
	freyjaGetModelCount();
	return 0;
}


int lua_freyjaModelCreate(lua_State *L)
{
	int integer_value = freyjaModelCreate();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaModelAddSkeleton(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	index_t skeleton = (int)lua_tonumber(L, 2);
	freyjaModelAddSkeleton(model, skeleton);
	return 0;
}


int lua_freyjaModelAddMesh(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	index_t mesh = (int)lua_tonumber(L, 2);
	freyjaModelAddMesh(model, mesh);
	return 0;
}


int lua_freyjaGetModelFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetModelFlags(model);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetModelMeshCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetModelMeshCount(model);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetModelMeshIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	uint32 element = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetModelMeshIndex(model, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetModelSkeleton(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetModelSkeleton(model);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaModelTransform(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	freyja_transform_action_t action = (freyja_transform_action_t)(int)lua_tonumber(L, 1);
	vec_t x = lua_tonumber(L, 3);
	vec_t y = lua_tonumber(L, 4);
	vec_t z = lua_tonumber(L, 5);
	freyjaModelTransform(model, action, x, y, z);
	return 0;
}


int lua_freyjaModelClear(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t model = (int)lua_tonumber(L, 1);
	freyjaModelClear(model);
	return 0;
}


int lua_freyjaGetBoneCount(lua_State *L)
{
	freyjaGetBoneCount();
	return 0;
}


int lua_freyjaBonePoolClear(lua_State *L)
{
	freyjaBonePoolClear();
	return 0;
}


int lua_freyjaBoneCreate(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t skeletonIndex = (int)lua_tonumber(L, 1);
	int integer_value = freyjaBoneCreate(skeletonIndex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaBoneDelete(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	freyjaBoneDelete(boneIndex);
	return 0;
}


int lua_freyjaBoneFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	byte flags = (int)lua_tonumber(L, 2);
	freyjaBoneFlags(boneIndex, flags);
	return 0;
}


int lua_freyjaBoneParent(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	index_t parentIndex = (int)lua_tonumber(L, 2);
	freyjaBoneParent(boneIndex, parentIndex);
	return 0;
}


int lua_freyjaBoneName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	const char *name = lua_tostring(L, 2);
	freyjaBoneName(boneIndex, name);
	return 0;
}


int lua_freyjaBoneRemoveChild(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	index_t childIndex = (int)lua_tonumber(L, 2);
	freyjaBoneRemoveChild(boneIndex, childIndex);
	return 0;
}


int lua_freyjaBoneAddChild(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	index_t childIndex = (int)lua_tonumber(L, 2);
	freyjaBoneAddChild(boneIndex, childIndex);
	return 0;
}


int lua_freyjaBoneTranslate3f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec_t x = lua_tonumber(L, 2);
	vec_t y = lua_tonumber(L, 3);
	vec_t z = lua_tonumber(L, 4);
	freyjaBoneTranslate3f(boneIndex, x, y, z);
	return 0;
}


int lua_freyjaBoneTranslate3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 2);
	xyz[1] = lua_tonumber(L, 3);
	xyz[2] = lua_tonumber(L, 4);
	freyjaBoneTranslate3fv(boneIndex, xyz);
	return 0;
}


int lua_freyjaBoneRotateEuler3f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec_t p = lua_tonumber(L, 2);
	vec_t h = lua_tonumber(L, 3);
	vec_t r = lua_tonumber(L, 4);
	freyjaBoneRotateEuler3f(boneIndex, p, h, r);
	return 0;
}


int lua_freyjaBoneRotateEuler3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec3_t phr;
	phr[0] = lua_tonumber(L, 2);
	phr[1] = lua_tonumber(L, 3);
	phr[2] = lua_tonumber(L, 4);
	freyjaBoneRotateEuler3fv(boneIndex, phr);
	return 0;
}


int lua_freyjaBoneRotateQuat4f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec_t w = lua_tonumber(L, 2);
	vec_t x = lua_tonumber(L, 3);
	vec_t y = lua_tonumber(L, 4);
	vec_t z = lua_tonumber(L, 5);
	freyjaBoneRotateQuat4f(boneIndex, w, x, y, z);
	return 0;
}


int lua_freyjaBoneRotateQuat4fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec4_t wxyz;
	wxyz[0] = lua_tonumber(L, 2);
	wxyz[1] = lua_tonumber(L, 3);
	wxyz[2] = lua_tonumber(L, 4);
	wxyz[3] = lua_tonumber(L, 5);
	freyjaBoneRotateQuat4fv(boneIndex, wxyz);
	return 0;
}


int lua_freyjaGetBoneRotationQuat4fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec4_t wxyz;
	wxyz[0] = lua_tonumber(L, 2);
	wxyz[1] = lua_tonumber(L, 3);
	wxyz[2] = lua_tonumber(L, 4);
	wxyz[3] = lua_tonumber(L, 5);
	freyjaGetBoneRotationQuat4fv(boneIndex, wxyz);
	return 0;
}


int lua_freyjaGetBoneRotationEuler3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec3_t phr;
	phr[0] = lua_tonumber(L, 2);
	phr[1] = lua_tonumber(L, 3);
	phr[2] = lua_tonumber(L, 4);
	freyjaGetBoneRotationEuler3fv(boneIndex, phr);
	return 0;
}


int lua_freyjaBoneTransform(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	freyja_transform_action_t action = (freyja_transform_action_t)(int)lua_tonumber(L, 1);
	vec_t x = lua_tonumber(L, 3);
	vec_t y = lua_tonumber(L, 4);
	vec_t z = lua_tonumber(L, 5);
	freyjaBoneTransform(boneIndex, action, x, y, z);
	return 0;
}


int lua_freyjaBoneTransform3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	freyja_transform_action_t action = (freyja_transform_action_t)(int)lua_tonumber(L, 1);
	vec3_t v;
	v[0] = lua_tonumber(L, 3);
	v[1] = lua_tonumber(L, 4);
	v[2] = lua_tonumber(L, 5);
	freyjaBoneTransform3fv(bone, action, v);
	return 0;
}


int lua_freyjaBoneInverseTransform3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	freyja_transform_action_t action = (freyja_transform_action_t)(int)lua_tonumber(L, 1);
	vec3_t v;
	v[0] = lua_tonumber(L, 3);
	v[1] = lua_tonumber(L, 4);
	v[2] = lua_tonumber(L, 5);
	freyjaBoneInverseTransform3fv(bone, action, v);
	return 0;
}


int lua_freyjaGetBoneNameString(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	const char *string_value = freyjaGetBoneNameString(boneIndex);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaGetBoneName(lua_State *L)
{
#warning "Unsupported function binding."
	freyjaPrintError("Invalid binding %s(), %s:%i", __func__, __FILE__, __LINE__);
#if FIXME
	/* No binding support for this type of method. */
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	uint32 size = (int)lua_tonumber(L, 2);
	const char *name = lua_tostring(L, 3);
	freyjaGetBoneName(boneIndex, size, name);
	return 0;
#endif // FIXME

	return 0;
}


int lua_freyjaGetBoneParent(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetBoneParent(boneIndex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetBoneBindPose16fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	freyjaGetBoneBindPose16fv(boneIndex);
	return 0;
}


int lua_freyjaGetBoneLocalBindTransform16fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	freyjaGetBoneLocalBindTransform16fv(boneIndex);
	return 0;
}


int lua_freyjaGetBoneWorldPos3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 2);
	xyz[1] = lua_tonumber(L, 3);
	xyz[2] = lua_tonumber(L, 4);
	freyjaGetBoneWorldPos3fv(boneIndex, xyz);
	return 0;
}


int lua_freyjaGetBoneTranslation3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 2);
	xyz[1] = lua_tonumber(L, 3);
	xyz[2] = lua_tonumber(L, 4);
	freyjaGetBoneTranslation3fv(boneIndex, xyz);
	return 0;
}


int lua_freyjaGetBoneSkeletonIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetBoneSkeletonIndex(boneIndex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetBoneChild(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	uint32 element = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetBoneChild(boneIndex, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetBoneChildCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t boneIndex = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetBoneChildCount(boneIndex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetBoneTrackCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetBoneTrackCount(bone);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetBonePosKeyframeTime(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec_t real_value = freyjaGetBonePosKeyframeTime(bone, track, key);
	lua_pushnumber(L, real_value);
	return 1;
}


int lua_freyjaBoneKeyframeMetadata(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	const char *metadata = lua_tostring(L, 4);
	freyjaBoneKeyframeMetadata(bone, track, key, metadata);
	return 0;
}


int lua_freyjaGetBoneKeyframeMetadata(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	const char *string_value = freyjaGetBoneKeyframeMetadata(bone, track, key);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaGetBonePosKeyframe3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 4);
	xyz[1] = lua_tonumber(L, 5);
	xyz[2] = lua_tonumber(L, 6);
	freyjaGetBonePosKeyframe3fv(bone, track, key, xyz);
	return 0;
}


int lua_freyjaGetBonePosKeyframeCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetBonePosKeyframeCount(bone, track);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetBoneRotKeyframeTime(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec_t real_value = freyjaGetBoneRotKeyframeTime(bone, track, key);
	lua_pushnumber(L, real_value);
	return 1;
}


int lua_freyjaGetBoneRotKeyframeEuler3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 4);
	xyz[1] = lua_tonumber(L, 5);
	xyz[2] = lua_tonumber(L, 6);
	freyjaGetBoneRotKeyframeEuler3fv(bone, track, key, xyz);
	return 0;
}


int lua_freyjaGetBoneRotKeyframeCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetBoneRotKeyframeCount(bone, track);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaBoneUpdateBindPose(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	freyjaBoneUpdateBindPose(bone);
	return 0;
}


int lua_freyjaBoneGetBindTransform(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 17 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	matrix_t m;
	m[0] = lua_tonumber(L, 2);
	m[1] = lua_tonumber(L, 3);
	m[2] = lua_tonumber(L, 4);
	m[3] = lua_tonumber(L, 5);
	m[4] = lua_tonumber(L, 6);
	m[5] = lua_tonumber(L, 7);
	m[6] = lua_tonumber(L, 8);
	m[7] = lua_tonumber(L, 9);
	m[8] = lua_tonumber(L, 10);
	m[9] = lua_tonumber(L, 11);
	m[10] = lua_tonumber(L, 12);
	m[11] = lua_tonumber(L, 13);
	m[12] = lua_tonumber(L, 14);
	m[13] = lua_tonumber(L, 15);
	m[14] = lua_tonumber(L, 16);
	m[15] = lua_tonumber(L, 17);
	freyjaBoneGetBindTransform(bone, m);
	return 0;
}


int lua_freyjaBoneGetBindTransformInverse(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 17 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	matrix_t m;
	m[0] = lua_tonumber(L, 2);
	m[1] = lua_tonumber(L, 3);
	m[2] = lua_tonumber(L, 4);
	m[3] = lua_tonumber(L, 5);
	m[4] = lua_tonumber(L, 6);
	m[5] = lua_tonumber(L, 7);
	m[6] = lua_tonumber(L, 8);
	m[7] = lua_tonumber(L, 9);
	m[8] = lua_tonumber(L, 10);
	m[9] = lua_tonumber(L, 11);
	m[10] = lua_tonumber(L, 12);
	m[11] = lua_tonumber(L, 13);
	m[12] = lua_tonumber(L, 14);
	m[13] = lua_tonumber(L, 15);
	m[14] = lua_tonumber(L, 16);
	m[15] = lua_tonumber(L, 17);
	freyjaBoneGetBindTransformInverse(bone, m);
	return 0;
}


int lua_freyjaBoneBindTransformVertex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	vec3_t p;
	p[0] = lua_tonumber(L, 2);
	p[1] = lua_tonumber(L, 3);
	p[2] = lua_tonumber(L, 4);
	vec_t w = lua_tonumber(L, 5);
	freyjaBoneBindTransformVertex(bone, p, w);
	return 0;
}


int lua_freyjaBoneTrackNew(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	int integer_value = freyjaBoneTrackNew(bone);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaBoneTrackDuration(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	vec_t duration = lua_tonumber(L, 3);
	freyjaBoneTrackDuration(bone, track, duration);
	return 0;
}


int lua_freyjaBoneTrackRate(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	vec_t fps = lua_tonumber(L, 3);
	freyjaBoneTrackRate(bone, track, fps);
	return 0;
}


int lua_freyjaBoneKeyFrameNew(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	vec_t time = lua_tonumber(L, 3);
	int integer_value = freyjaBoneKeyFrameNew(bone, track, time);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaBonePosKeyFrame3f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec_t x = lua_tonumber(L, 4);
	vec_t y = lua_tonumber(L, 5);
	vec_t z = lua_tonumber(L, 6);
	freyjaBonePosKeyFrame3f(bone, track, key, x, y, z);
	return 0;
}


int lua_freyjaBoneRotKeyFrameEuler3f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec_t x = lua_tonumber(L, 4);
	vec_t y = lua_tonumber(L, 5);
	vec_t z = lua_tonumber(L, 6);
	freyjaBoneRotKeyFrameEuler3f(bone, track, key, x, y, z);
	return 0;
}


int lua_freyjaBoneRotKeyFrameQuat4f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 7 )
		return 0;

	index_t bone = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	vec_t w = lua_tonumber(L, 4);
	vec_t x = lua_tonumber(L, 5);
	vec_t y = lua_tonumber(L, 6);
	vec_t z = lua_tonumber(L, 7);
	freyjaBoneRotKeyFrameQuat4f(bone, track, key, w, x, y, z);
	return 0;
}


int lua_freyjaLightCreate(lua_State *L)
{
	freyjaLightCreate();
	return 0;
}


int lua_freyjaGetLightCount(lua_State *L)
{
	int integer_value = freyjaGetLightCount();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaLightDelete(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	freyjaLightDelete(lightIndex);
	return 0;
}


int lua_freyjaLightPosition4v(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t position;
	position[0] = lua_tonumber(L, 2);
	position[1] = lua_tonumber(L, 3);
	position[2] = lua_tonumber(L, 4);
	position[3] = lua_tonumber(L, 5);
	freyjaLightPosition4v(lightIndex, position);
	return 0;
}


int lua_freyjaLightAmbient(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t ambient;
	ambient[0] = lua_tonumber(L, 2);
	ambient[1] = lua_tonumber(L, 3);
	ambient[2] = lua_tonumber(L, 4);
	ambient[3] = lua_tonumber(L, 5);
	freyjaLightAmbient(lightIndex, ambient);
	return 0;
}


int lua_freyjaLightDiffuse(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t diffuse;
	diffuse[0] = lua_tonumber(L, 2);
	diffuse[1] = lua_tonumber(L, 3);
	diffuse[2] = lua_tonumber(L, 4);
	diffuse[3] = lua_tonumber(L, 5);
	freyjaLightDiffuse(lightIndex, diffuse);
	return 0;
}


int lua_freyjaLightSpecular(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t specular;
	specular[0] = lua_tonumber(L, 2);
	specular[1] = lua_tonumber(L, 3);
	specular[2] = lua_tonumber(L, 4);
	specular[3] = lua_tonumber(L, 5);
	freyjaLightSpecular(lightIndex, specular);
	return 0;
}


int lua_freyjaGetLightPosition4v(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t position;
	position[0] = lua_tonumber(L, 2);
	position[1] = lua_tonumber(L, 3);
	position[2] = lua_tonumber(L, 4);
	position[3] = lua_tonumber(L, 5);
	freyjaGetLightPosition4v(lightIndex, position);
	return 0;
}


int lua_freyjaGetLightAmbient(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t ambient;
	ambient[0] = lua_tonumber(L, 2);
	ambient[1] = lua_tonumber(L, 3);
	ambient[2] = lua_tonumber(L, 4);
	ambient[3] = lua_tonumber(L, 5);
	freyjaGetLightAmbient(lightIndex, ambient);
	return 0;
}


int lua_freyjaGetLightDiffuse(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t diffuse;
	diffuse[0] = lua_tonumber(L, 2);
	diffuse[1] = lua_tonumber(L, 3);
	diffuse[2] = lua_tonumber(L, 4);
	diffuse[3] = lua_tonumber(L, 5);
	freyjaGetLightDiffuse(lightIndex, diffuse);
	return 0;
}


int lua_freyjaGetLightSpecular(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t lightIndex = (int)lua_tonumber(L, 1);
	vec4_t specular;
	specular[0] = lua_tonumber(L, 2);
	specular[1] = lua_tonumber(L, 3);
	specular[2] = lua_tonumber(L, 4);
	specular[3] = lua_tonumber(L, 5);
	freyjaGetLightSpecular(lightIndex, specular);
	return 0;
}


int lua_freyjaMaterialCreate(lua_State *L)
{
	freyjaMaterialCreate();
	return 0;
}


int lua_freyjaMaterialClearAll(lua_State *L)
{
	freyjaMaterialClearAll();
	return 0;
}


int lua_freyjaGetMaterialCount(lua_State *L)
{
	int integer_value = freyjaGetMaterialCount();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMaterialIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	uint32 element = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMaterialIndex(material, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMaterialName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	const char *string_value = freyjaGetMaterialName(material);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaGetMaterialFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMaterialFlags(material);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMaterialShader(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMaterialShader(material);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMaterialTexture(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMaterialTexture(material);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMaterialShaderName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	const char *string_value = freyjaGetMaterialShaderName(material);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaGetMaterialTextureName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	const char *string_value = freyjaGetMaterialTextureName(material);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaGetMaterialAmbient(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t ambient;
	ambient[0] = lua_tonumber(L, 2);
	ambient[1] = lua_tonumber(L, 3);
	ambient[2] = lua_tonumber(L, 4);
	ambient[3] = lua_tonumber(L, 5);
	freyjaGetMaterialAmbient(material, ambient);
	return 0;
}


int lua_freyjaGetMaterialDiffuse(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t diffuse;
	diffuse[0] = lua_tonumber(L, 2);
	diffuse[1] = lua_tonumber(L, 3);
	diffuse[2] = lua_tonumber(L, 4);
	diffuse[3] = lua_tonumber(L, 5);
	freyjaGetMaterialDiffuse(material, diffuse);
	return 0;
}


int lua_freyjaGetMaterialSpecular(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t specular;
	specular[0] = lua_tonumber(L, 2);
	specular[1] = lua_tonumber(L, 3);
	specular[2] = lua_tonumber(L, 4);
	specular[3] = lua_tonumber(L, 5);
	freyjaGetMaterialSpecular(material, specular);
	return 0;
}


int lua_freyjaGetMaterialEmissive(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t emissive;
	emissive[0] = lua_tonumber(L, 2);
	emissive[1] = lua_tonumber(L, 3);
	emissive[2] = lua_tonumber(L, 4);
	emissive[3] = lua_tonumber(L, 5);
	freyjaGetMaterialEmissive(material, emissive);
	return 0;
}


int lua_freyjaGetMaterialShininess(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec_t real_value = freyjaGetMaterialShininess(material);
	lua_pushnumber(L, real_value);
	return 1;
}


int lua_freyjaGetMaterialTransparency(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec_t real_value = freyjaGetMaterialTransparency(material);
	lua_pushnumber(L, real_value);
	return 1;
}


int lua_freyjaGetMaterialBlendSource(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMaterialBlendSource(material);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMaterialBlendDestination(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMaterialBlendDestination(material);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMaterialName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	const char *name = lua_tostring(L, 2);
	freyjaMaterialName(material, name);
	return 0;
}


int lua_freyjaMaterialClearFlag(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	uint32 flag = (int)lua_tonumber(L, 2);
	freyjaMaterialClearFlag(material, flag);
	return 0;
}


int lua_freyjaMaterialSetFlag(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	uint32 flag = (int)lua_tonumber(L, 2);
	freyjaMaterialSetFlag(material, flag);
	return 0;
}


int lua_freyjaMaterialFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	uint32 flags = (int)lua_tonumber(L, 2);
	freyjaMaterialFlags(material, flags);
	return 0;
}


int lua_freyjaMaterialShaderName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	const char *filename = lua_tostring(L, 2);
	freyjaMaterialShaderName(material, filename);
	return 0;
}


int lua_freyjaMaterialTextureName(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	const char *name = lua_tostring(L, 2);
	freyjaMaterialTextureName(material, name);
	return 0;
}


int lua_freyjaMaterialShader(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	index_t shader = (int)lua_tonumber(L, 2);
	freyjaMaterialShader(material, shader);
	return 0;
}


int lua_freyjaMaterialTexture(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	index_t texture = (int)lua_tonumber(L, 2);
	freyjaMaterialTexture(material, texture);
	return 0;
}


int lua_freyjaMaterialAmbient(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t ambient;
	ambient[0] = lua_tonumber(L, 2);
	ambient[1] = lua_tonumber(L, 3);
	ambient[2] = lua_tonumber(L, 4);
	ambient[3] = lua_tonumber(L, 5);
	freyjaMaterialAmbient(material, ambient);
	return 0;
}


int lua_freyjaMaterialDiffuse(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t diffuse;
	diffuse[0] = lua_tonumber(L, 2);
	diffuse[1] = lua_tonumber(L, 3);
	diffuse[2] = lua_tonumber(L, 4);
	diffuse[3] = lua_tonumber(L, 5);
	freyjaMaterialDiffuse(material, diffuse);
	return 0;
}


int lua_freyjaMaterialSpecular(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t specular;
	specular[0] = lua_tonumber(L, 2);
	specular[1] = lua_tonumber(L, 3);
	specular[2] = lua_tonumber(L, 4);
	specular[3] = lua_tonumber(L, 5);
	freyjaMaterialSpecular(material, specular);
	return 0;
}


int lua_freyjaMaterialEmissive(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec4_t emissive;
	emissive[0] = lua_tonumber(L, 2);
	emissive[1] = lua_tonumber(L, 3);
	emissive[2] = lua_tonumber(L, 4);
	emissive[3] = lua_tonumber(L, 5);
	freyjaMaterialEmissive(material, emissive);
	return 0;
}


int lua_freyjaMaterialShininess(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec_t exponent = lua_tonumber(L, 2);
	freyjaMaterialShininess(material, exponent);
	return 0;
}


int lua_freyjaMaterialTransparency(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	vec_t transparency = lua_tonumber(L, 2);
	freyjaMaterialTransparency(material, transparency);
	return 0;
}


int lua_freyjaMaterialBlendSource(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	uint32 factor = (int)lua_tonumber(L, 2);
	freyjaMaterialBlendSource(material, factor);
	return 0;
}


int lua_freyjaMaterialBlendDestination(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t material = (int)lua_tonumber(L, 1);
	uint32 factor = (int)lua_tonumber(L, 2);
	freyjaMaterialBlendDestination(material, factor);
	return 0;
}


int lua_freyjaPakBegin(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	const char *filename = lua_tostring(L, 1);
	freyjaPakBegin(filename);
	return 0;
}


int lua_freyjaPakAddDecoderFunction2s(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	const char *module = lua_tostring(L, 1);
	const char *symbol = lua_tostring(L, 2);
	freyjaPakAddDecoderFunction2s(module, symbol);
	return 0;
}


int lua_freyjaPakAddFullPathFile(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t pakIndex = (int)lua_tonumber(L, 1);
	const char *vfsFilename = lua_tostring(L, 2);
	int32 offset = (int)lua_tonumber(L, 3);
	int32 size = (int)lua_tonumber(L, 4);
	freyjaPakAddFullPathFile(pakIndex, vfsFilename, offset, size);
	return 0;
}


int lua_freyjaPakAddFullPathFileXOR(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t pakIndex = (int)lua_tonumber(L, 1);
	char key = (int)lua_tonumber(L, 2);
	const char *vfsFilename = lua_tostring(L, 3);
	int32 offset = (int)lua_tonumber(L, 4);
	int32 size = (int)lua_tonumber(L, 5);
	freyjaPakAddFullPathFileXOR(pakIndex, key, vfsFilename, offset, size);
	return 0;
}


int lua_freyjaPakEnd(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t pakIndex = (int)lua_tonumber(L, 1);
	freyjaPakEnd(pakIndex);
	return 0;
}


int lua_freyjaMeshCreate(lua_State *L)
{
	freyjaMeshCreate();
	return 0;
}


int lua_freyjaMeshCopy(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaMeshCopy(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshDelete(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshDelete(mesh);
	return 0;
}


int lua_freyjaMeshMaterial(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t material = (int)lua_tonumber(L, 2);
	freyjaMeshMaterial(mesh, material);
	return 0;
}


int lua_freyjaMeshPosition(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t meshIndex = (int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 2);
	xyz[1] = lua_tonumber(L, 3);
	xyz[2] = lua_tonumber(L, 4);
	freyjaMeshPosition(meshIndex, xyz);
	return 0;
}


int lua_freyjaMeshName1s(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t meshIndex = (int)lua_tonumber(L, 1);
	const char *name = lua_tostring(L, 2);
	freyjaMeshName1s(meshIndex, name);
	return 0;
}


int lua_freyjaMeshFlags1u(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	uint32 flags = (int)lua_tonumber(L, 1);
	freyjaMeshFlags1u(flags);
	return 0;
}


int lua_freyjaMeshTransform3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyja_transform_action_t action = (freyja_transform_action_t)(int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 3);
	xyz[1] = lua_tonumber(L, 4);
	xyz[2] = lua_tonumber(L, 5);
	freyjaMeshTransform3fv(mesh, action, xyz);
	return 0;
}


int lua_freyjaMeshVertexCreate3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 2);
	xyz[1] = lua_tonumber(L, 3);
	xyz[2] = lua_tonumber(L, 4);
	int integer_value = freyjaMeshVertexCreate3fv(mesh, xyz);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshVertexPos3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 3);
	xyz[1] = lua_tonumber(L, 4);
	xyz[2] = lua_tonumber(L, 5);
	freyjaMeshVertexPos3fv(mesh, vertex, xyz);
	return 0;
}


int lua_freyjaMeshVertexNormal3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 3);
	xyz[1] = lua_tonumber(L, 4);
	xyz[2] = lua_tonumber(L, 5);
	freyjaMeshVertexNormal3fv(mesh, vertex, xyz);
	return 0;
}


int lua_freyjaMeshTexCoordCreate2fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec2_t uv;
	uv[0] = lua_tonumber(L, 2);
	uv[1] = lua_tonumber(L, 3);
	int integer_value = freyjaMeshTexCoordCreate2fv(mesh, uv);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshTexCoordCreate2f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec_t u = lua_tonumber(L, 2);
	vec_t v = lua_tonumber(L, 3);
	int integer_value = freyjaMeshTexCoordCreate2f(mesh, u, v);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshTexCoordCreate3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec3_t uvw;
	uvw[0] = lua_tonumber(L, 2);
	uvw[1] = lua_tonumber(L, 3);
	uvw[2] = lua_tonumber(L, 4);
	int integer_value = freyjaMeshTexCoordCreate3fv(mesh, uvw);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshTexCoordCreate3f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec_t u = lua_tonumber(L, 2);
	vec_t v = lua_tonumber(L, 3);
	vec_t w = lua_tonumber(L, 4);
	int integer_value = freyjaMeshTexCoordCreate3f(mesh, u, v, w);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshTexCoord2fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t texcoord = (int)lua_tonumber(L, 2);
	vec2_t uv;
	uv[0] = lua_tonumber(L, 3);
	uv[1] = lua_tonumber(L, 4);
	freyjaMeshTexCoord2fv(mesh, texcoord, uv);
	return 0;
}


int lua_freyjaMeshVertexTexCoord3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t texcoord = (int)lua_tonumber(L, 2);
	vec3_t uvw;
	uvw[0] = lua_tonumber(L, 3);
	uvw[1] = lua_tonumber(L, 4);
	uvw[2] = lua_tonumber(L, 5);
	freyjaMeshVertexTexCoord3fv(mesh, texcoord, uvw);
	return 0;
}


int lua_freyjaMeshClampTexCoords(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshClampTexCoords(mesh);
	return 0;
}


int lua_freyjaMeshPolygonCreate(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaMeshPolygonCreate(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshPolygonDelete(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	freyjaMeshPolygonDelete(mesh, polygon);
	return 0;
}


int lua_freyjaMeshPolygonAddVertex1i(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	index_t vertex = (int)lua_tonumber(L, 3);
	freyjaMeshPolygonAddVertex1i(mesh, polygon, vertex);
	return 0;
}


int lua_freyjaMeshPolygonAddTexCoord1i(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	index_t texcoord = (int)lua_tonumber(L, 3);
	freyjaMeshPolygonAddTexCoord1i(mesh, polygon, texcoord);
	return 0;
}


int lua_freyjaMeshPolygonMaterial(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	index_t material = (int)lua_tonumber(L, 3);
	freyjaMeshPolygonMaterial(mesh, polygon, material);
	return 0;
}


int lua_freyjaMeshPolygonFlipNormal(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t face = (int)lua_tonumber(L, 2);
	freyjaMeshPolygonFlipNormal(mesh, face);
	return 0;
}


int lua_freyjaMeshPolygonComputeNormal(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t face = (int)lua_tonumber(L, 2);
	freyjaMeshPolygonComputeNormal(mesh, face);
	return 0;
}


int lua_freyjaMeshPolygonNormal(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t face = (int)lua_tonumber(L, 2);
	vec3_t normal;
	normal[0] = lua_tonumber(L, 3);
	normal[1] = lua_tonumber(L, 4);
	normal[2] = lua_tonumber(L, 5);
	freyjaMeshPolygonNormal(mesh, face, normal);
	return 0;
}


int lua_freyjaMeshPolygonClearFlag1u(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t face = (int)lua_tonumber(L, 2);
	byte flag = (int)lua_tonumber(L, 3);
	freyjaMeshPolygonClearFlag1u(mesh, face, flag);
	return 0;
}


int lua_freyjaMeshPolygonSetFlag1u(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t face = (int)lua_tonumber(L, 2);
	byte flag = (int)lua_tonumber(L, 3);
	freyjaMeshPolygonSetFlag1u(mesh, face, flag);
	return 0;
}


int lua_freyjaMeshPolygonGroup1u(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t face = (int)lua_tonumber(L, 2);
	uint32 group = (int)lua_tonumber(L, 3);
	freyjaMeshPolygonGroup1u(mesh, face, group);
	return 0;
}


int lua_freyjaMeshUVMapPlanar(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshUVMapPlanar(mesh);
	return 0;
}


int lua_freyjaMeshUVMapSpherical(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshUVMapSpherical(mesh);
	return 0;
}


int lua_freyjaMeshUVMapCylindrical(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshUVMapCylindrical(mesh);
	return 0;
}


int lua_freyjaMeshTesselateTriangles(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshTesselateTriangles(mesh);
	return 0;
}


int lua_freyjaMeshNormalFlip(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshNormalFlip(mesh);
	return 0;
}


int lua_freyjaMeshGenerateVertexNormals(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	freyjaMeshGenerateVertexNormals(mesh);
	return 0;
}


int lua_freyjaMeshPolygonExtrudeQuad1f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t quad = (int)lua_tonumber(L, 2);
	vec3_t n;
	n[0] = lua_tonumber(L, 3);
	n[1] = lua_tonumber(L, 4);
	n[2] = lua_tonumber(L, 5);
	freyjaMeshPolygonExtrudeQuad1f(mesh, quad, n);
	return 0;
}


int lua_freyjaMeshVertexWeight(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	index_t bone = (int)lua_tonumber(L, 3);
	vec_t weight = lua_tonumber(L, 4);
	freyjaMeshVertexWeight(mesh, vertex, bone, weight);
	return 0;
}


int lua_freyjaMeshTexCoordWeld(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t a = (int)lua_tonumber(L, 2);
	index_t b = (int)lua_tonumber(L, 3);
	int integer_value = freyjaMeshTexCoordWeld(mesh, a, b);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshVertexWeld(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t a = (int)lua_tonumber(L, 2);
	index_t b = (int)lua_tonumber(L, 3);
	int integer_value = freyjaMeshVertexWeld(mesh, a, b);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshUpdateBlendVertices(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	vec_t time = lua_tonumber(L, 3);
	freyjaMeshUpdateBlendVertices(mesh, track, time);
	return 0;
}


int lua_freyjaMeshVertexTrackNew(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec_t duration = lua_tonumber(L, 2);
	vec_t rate = lua_tonumber(L, 3);
	int integer_value = freyjaMeshVertexTrackNew(mesh, duration, rate);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshVertexKeyFrameNew(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	vec_t time = lua_tonumber(L, 3);
	int integer_value = freyjaMeshVertexKeyFrameNew(mesh, track, time);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshVertexKeyFrame3f(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 7 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	index_t key = (int)lua_tonumber(L, 3);
	uint32 vert = (int)lua_tonumber(L, 4);
	vec_t x = lua_tonumber(L, 5);
	vec_t y = lua_tonumber(L, 6);
	vec_t z = lua_tonumber(L, 7);
	freyjaMeshVertexKeyFrame3f(mesh, track, key, vert, x, y, z);
	return 0;
}


int lua_freyjaMeshPolygonSplit(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	freyjaMeshPolygonSplit(mesh, polygon);
	return 0;
}


int lua_freyjaGetMeshCount(lua_State *L)
{
	int integer_value = freyjaGetMeshCount();
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshBoundingBox(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 7 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec3_t min;
	min[0] = lua_tonumber(L, 2);
	min[1] = lua_tonumber(L, 3);
	min[2] = lua_tonumber(L, 4);
	vec3_t max;
	max[0] = lua_tonumber(L, 5);
	max[1] = lua_tonumber(L, 6);
	max[2] = lua_tonumber(L, 7);
	freyjaGetMeshBoundingBox(mesh, min, max);
	return 0;
}


int lua_freyjaGetMeshBoundingSphere(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec3_t origin;
	origin[0] = lua_tonumber(L, 2);
	origin[1] = lua_tonumber(L, 3);
	origin[2] = lua_tonumber(L, 4);
	vec_t radius = lua_tonumber(L, 5);
	freyjaGetMeshBoundingSphere(mesh, origin, radius);
	return 0;
}


int lua_freyjaGetMeshFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshFlags(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPosition(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 2);
	xyz[1] = lua_tonumber(L, 3);
	xyz[2] = lua_tonumber(L, 4);
	freyjaGetMeshPosition(mesh, xyz);
	return 0;
}


int lua_freyjaGetMeshNameString(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t meshIndex = (int)lua_tonumber(L, 1);
	const char *string_value = freyjaGetMeshNameString(meshIndex);
	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaGetMeshVertexFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshVertexFlags(mesh, vertex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexPos3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 3);
	xyz[1] = lua_tonumber(L, 4);
	xyz[2] = lua_tonumber(L, 5);
	freyjaGetMeshVertexPos3fv(mesh, vertex, xyz);
	return 0;
}


int lua_freyjaGetMeshVertexNormal3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 3);
	xyz[1] = lua_tonumber(L, 4);
	xyz[2] = lua_tonumber(L, 5);
	freyjaGetMeshVertexNormal3fv(mesh, vertex, xyz);
	return 0;
}


int lua_freyjaGetMeshVertexTexCoord3fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vert = (int)lua_tonumber(L, 2);
	vec3_t xyz;
	xyz[0] = lua_tonumber(L, 3);
	xyz[1] = lua_tonumber(L, 4);
	xyz[2] = lua_tonumber(L, 5);
	freyjaGetMeshVertexTexCoord3fv(mesh, vert, xyz);
	return 0;
}


int lua_freyjaGetMeshVertexTexCoord(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshVertexTexCoord(mesh, vertex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexWeightCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshVertexWeightCount(mesh, vertex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexWeightIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	uint32 element = (int)lua_tonumber(L, 3);
	int integer_value = freyjaGetMeshVertexWeightIndex(mesh, vertex, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexPolygonRefCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshVertexPolygonRefCount(mesh, vertex);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexPolygonRefIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t vertex = (int)lua_tonumber(L, 2);
	uint32 element = (int)lua_tonumber(L, 3);
	int integer_value = freyjaGetMeshVertexPolygonRefIndex(mesh, vertex, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshTexCoord2fv(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t texcoord = (int)lua_tonumber(L, 2);
	vec2_t uv;
	uv[0] = lua_tonumber(L, 3);
	uv[1] = lua_tonumber(L, 4);
	freyjaGetMeshTexCoord2fv(mesh, texcoord, uv);
	return 0;
}


int lua_freyjaGetMeshPolygonFlags(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshPolygonFlags(mesh, polygon);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonGroup(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshPolygonGroup(mesh, polygon);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonEdgeCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshPolygonEdgeCount(mesh, polygon);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonVertexCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshPolygonVertexCount(mesh, polygon);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonVertexIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	uint32 element = (int)lua_tonumber(L, 3);
	int integer_value = freyjaGetMeshPolygonVertexIndex(mesh, polygon, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonTexCoordCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshPolygonTexCoordCount(mesh, polygon);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonTexCoordIndex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 3 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	uint32 element = (int)lua_tonumber(L, 3);
	int integer_value = freyjaGetMeshPolygonTexCoordIndex(mesh, polygon, element);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonMaterial(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t polygon = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshPolygonMaterial(mesh, polygon);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshTexCoordCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshTexCoordCount(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshVertexCount(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshNormalCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshNormalCount(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshPolygonCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshPolygonCount(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshBlendVertices(lua_State *L)
{
#warning "Unsupported function binding."
	freyjaPrintError("Invalid binding %s(), %s:%i", __func__, __FILE__, __LINE__);
#if FIXME
	/* No binding support for this type of method. */
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	vec_t real_value = freyjaGetMeshBlendVertices(mesh);
	lua_pushnumber(L, real_value);
	return 1;
#endif // FIXME

	return 0;
}


int lua_freyjaGetMeshWeightValue(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t weight = (int)lua_tonumber(L, 2);
	vec_t real_value = freyjaGetMeshWeightValue(mesh, weight);
	lua_pushnumber(L, real_value);
	return 1;
}


int lua_freyjaGetMeshWeightBone(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t weight = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshWeightBone(mesh, weight);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshWeightVertex(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t weight = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshWeightVertex(mesh, weight);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshWeight(lua_State *L)
{
#warning "Unsupported function binding."
	freyjaPrintError("Invalid binding %s(), %s:%i", __func__, __FILE__, __LINE__);
#if FIXME
	/* No binding support for this type of method. */
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t weight = (int)lua_tonumber(L, 2);
	index_t* vertex = (int)lua_tonumber(L, 3);
	index_t* bone = (int)lua_tonumber(L, 4);
	vec_t* weightv = lua_tonumber(L, 5);
	freyjaGetMeshWeight(mesh, weight, vertex, bone, weightv);
	return 0;
#endif // FIXME

	return 0;
}


int lua_freyjaGetMeshWeightCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshWeightCount(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexTrackCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	int integer_value = freyjaGetMeshVertexTrackCount(mesh);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaGetMeshVertexKeyFrameCount(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 2 )
		return 0;

	index_t mesh = (int)lua_tonumber(L, 1);
	index_t track = (int)lua_tonumber(L, 2);
	int integer_value = freyjaGetMeshVertexKeyFrameCount(mesh, track);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateSheet(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t size = lua_tonumber(L, 4);
	uint32 rows = (int)lua_tonumber(L, 5);
	uint32 columns = (int)lua_tonumber(L, 6);
	int integer_value = freyjaMeshCreateSheet(origin, size, rows, columns);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateLattice(lua_State *L)
{
#warning "Unsupported function binding."
	freyjaPrintError("Invalid binding %s(), %s:%i", __func__, __FILE__, __LINE__);
#if FIXME
	/* No binding support for this type of method. */
	int stack_count = lua_gettop(L);
	if ( stack_count < 7 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t size = lua_tonumber(L, 4);
	uint32 rows = (int)lua_tonumber(L, 5);
	uint32 columns = (int)lua_tonumber(L, 6);
	uint32 layers = (int)lua_tonumber(L, 7);
	int integer_value = freyjaMeshCreateLattice(origin, size, rows, columns, layers);
	lua_pushnumber(L, integer_value);
	return 1;
#endif // FIXME

	return 0;
}


int lua_freyjaMeshCreateCube(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 4 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t size = lua_tonumber(L, 4);
	int integer_value = freyjaMeshCreateCube(origin, size);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateRing(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t radius = lua_tonumber(L, 4);
	uint32 count = (int)lua_tonumber(L, 5);
	uint32 rings = (int)lua_tonumber(L, 6);
	int integer_value = freyjaMeshCreateRing(origin, radius, count, rings);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateCircle(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 5 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t radius = lua_tonumber(L, 4);
	uint32 count = (int)lua_tonumber(L, 5);
	int integer_value = freyjaMeshCreateCircle(origin, radius, count);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateCone(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t height = lua_tonumber(L, 4);
	vec_t radius = lua_tonumber(L, 5);
	uint32 wedges = (int)lua_tonumber(L, 6);
	int integer_value = freyjaMeshCreateCone(origin, height, radius, wedges);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateCylinder(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 7 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t height = lua_tonumber(L, 4);
	vec_t radius = lua_tonumber(L, 5);
	uint32 sides = (int)lua_tonumber(L, 6);
	uint32 rings = (int)lua_tonumber(L, 7);
	int integer_value = freyjaMeshCreateCylinder(origin, height, radius, sides, rings);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateSphere(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 6 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t radius = lua_tonumber(L, 4);
	int32 sides = (int)lua_tonumber(L, 5);
	int32 rings = (int)lua_tonumber(L, 6);
	int integer_value = freyjaMeshCreateSphere(origin, radius, sides, rings);
	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaMeshCreateTube(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 7 )
		return 0;

	vec3_t origin;
	origin[0] = lua_tonumber(L, 1);
	origin[1] = lua_tonumber(L, 2);
	origin[2] = lua_tonumber(L, 3);
	vec_t height = lua_tonumber(L, 4);
	vec_t radius = lua_tonumber(L, 5);
	int32 sides = (int)lua_tonumber(L, 6);
	int32 rings = (int)lua_tonumber(L, 7);
	int integer_value = freyjaMeshCreateTube(origin, height, radius, sides, rings);
	lua_pushnumber(L, integer_value);
	return 1;
}


// Query hooks
extern "C" {	
	index_t freyjaQueryBegin();
	void freyjaQueryEnd(index_t query);
	void freyjaQueryInteger(index_t query, const char *symbol, int32 *i);
	void freyjaQueryFloat(index_t query, const char *symbol, vec_t *r);
	void freyjaQueryString(index_t query, const char *symbol, const char **s);
}


int lua_freyjaQueryInteger(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	const char *symbol = lua_tostring(L, 1);

	int integer_value;
	index_t q = freyjaQueryBegin();
	freyjaQueryInteger(q, symbol, &integer_value);
	freyjaQueryEnd(q);

	lua_pushnumber(L, integer_value);
	return 1;
}


int lua_freyjaQueryFloat(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	const char *symbol = lua_tostring(L, 1);

	float real_value;
	index_t q = freyjaQueryBegin();
	freyjaQueryFloat(q, symbol, &real_value);
	freyjaQueryEnd(q);

	lua_pushnumber(L, real_value);
	return 1;
}


int lua_freyjaQueryString(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	const char *symbol = lua_tostring(L, 1);

	const char *string_value;
	index_t q = freyjaQueryBegin();
	freyjaQueryString(q, symbol, &string_value);
	freyjaQueryEnd(q);

	lua_pushstring(L, string_value);
	return 1;
}


int lua_freyjaPrintMessage(lua_State *L)
{
	int stack_count = lua_gettop(L);
	if ( stack_count < 1 )
		return 0;

	const char *msg = lua_tostring(L, 1);

	if (msg)
	{
		freyjaPrintMessage(msg);
	}
	return 0;
}


typedef struct {
	const char *symbol;
	int (*func)(lua_State*);
} lua_freyja_bind_t;


lua_freyja_bind_t gLibFreyja_LuaBinds[] = {
	{ "freyjaQueryInteger", lua_freyjaQueryInteger },
	{ "freyjaQueryFloat", lua_freyjaQueryFloat },
	{ "freyjaQueryString", lua_freyjaQueryString },
	{ "freyjaPrintMessage", lua_freyjaPrintMessage },

	{ "freyjaSkeletonCreate", lua_freyjaSkeletonCreate },
	{ "freyjaSkeletonPoolClear", lua_freyjaSkeletonPoolClear },
	{ "freyjaSkeletonDelete", lua_freyjaSkeletonDelete },
	{ "freyjaSkeletonUpdateBones", lua_freyjaSkeletonUpdateBones },
	{ "freyjaSkeletonAddBone", lua_freyjaSkeletonAddBone },
	{ "freyjaSkeletonRootIndex", lua_freyjaSkeletonRootIndex },
	{ "freyjaSkeletonTransform", lua_freyjaSkeletonTransform },
	{ "freyjaGetSkeletonCount", lua_freyjaGetSkeletonCount },
	{ "freyjaGetSkeletonBoneCount", lua_freyjaGetSkeletonBoneCount },
	{ "freyjaGetSkeletonBoneIndex", lua_freyjaGetSkeletonBoneIndex },
	{ "freyjaGetSkeletonRootIndex", lua_freyjaGetSkeletonRootIndex },
	{ "freyjaSkeletonName", lua_freyjaSkeletonName },
	{ "freyjaGetSkeletonName", lua_freyjaGetSkeletonName },
	{ "freyjaTextureCreateFilename", lua_freyjaTextureCreateFilename },
	{ "freyjaTextureCreateBuffer", lua_freyjaTextureCreateBuffer },
	{ "freyjaTextureDelete", lua_freyjaTextureDelete },
	{ "freyjaGetTextureImage", lua_freyjaGetTextureImage },
	{ "freyjaGetTexturePoolCount", lua_freyjaGetTexturePoolCount },
	{ "freyjaGetTextureCount", lua_freyjaGetTextureCount },
	{ "freyjaGetModelCount", lua_freyjaGetModelCount },
	{ "freyjaModelCreate", lua_freyjaModelCreate },
	{ "freyjaModelAddSkeleton", lua_freyjaModelAddSkeleton },
	{ "freyjaModelAddMesh", lua_freyjaModelAddMesh },
	{ "freyjaGetModelFlags", lua_freyjaGetModelFlags },
	{ "freyjaGetModelMeshCount", lua_freyjaGetModelMeshCount },
	{ "freyjaGetModelMeshIndex", lua_freyjaGetModelMeshIndex },
	{ "freyjaGetModelSkeleton", lua_freyjaGetModelSkeleton },
	{ "freyjaModelTransform", lua_freyjaModelTransform },
	{ "freyjaModelClear", lua_freyjaModelClear },
	{ "freyjaGetBoneCount", lua_freyjaGetBoneCount },
	{ "freyjaBonePoolClear", lua_freyjaBonePoolClear },
	{ "freyjaBoneCreate", lua_freyjaBoneCreate },
	{ "freyjaBoneDelete", lua_freyjaBoneDelete },
	{ "freyjaBoneFlags", lua_freyjaBoneFlags },
	{ "freyjaBoneParent", lua_freyjaBoneParent },
	{ "freyjaBoneName", lua_freyjaBoneName },
	{ "freyjaBoneRemoveChild", lua_freyjaBoneRemoveChild },
	{ "freyjaBoneAddChild", lua_freyjaBoneAddChild },
	{ "freyjaBoneTranslate3f", lua_freyjaBoneTranslate3f },
	{ "freyjaBoneTranslate3fv", lua_freyjaBoneTranslate3fv },
	{ "freyjaBoneRotateEuler3f", lua_freyjaBoneRotateEuler3f },
	{ "freyjaBoneRotateEuler3fv", lua_freyjaBoneRotateEuler3fv },
	{ "freyjaBoneRotateQuat4f", lua_freyjaBoneRotateQuat4f },
	{ "freyjaBoneRotateQuat4fv", lua_freyjaBoneRotateQuat4fv },
	{ "freyjaGetBoneRotationQuat4fv", lua_freyjaGetBoneRotationQuat4fv },
	{ "freyjaGetBoneRotationEuler3fv", lua_freyjaGetBoneRotationEuler3fv },
	{ "freyjaBoneTransform", lua_freyjaBoneTransform },
	{ "freyjaBoneTransform3fv", lua_freyjaBoneTransform3fv },
	{ "freyjaBoneInverseTransform3fv", lua_freyjaBoneInverseTransform3fv },
	{ "freyjaGetBoneNameString", lua_freyjaGetBoneNameString },
	{ "freyjaGetBoneName", lua_freyjaGetBoneName },
	{ "freyjaGetBoneParent", lua_freyjaGetBoneParent },
	{ "freyjaGetBoneBindPose16fv", lua_freyjaGetBoneBindPose16fv },
	{ "freyjaGetBoneLocalBindTransform16fv", lua_freyjaGetBoneLocalBindTransform16fv },
	{ "freyjaGetBoneWorldPos3fv", lua_freyjaGetBoneWorldPos3fv },
	{ "freyjaGetBoneTranslation3fv", lua_freyjaGetBoneTranslation3fv },
	{ "freyjaGetBoneSkeletonIndex", lua_freyjaGetBoneSkeletonIndex },
	{ "freyjaGetBoneChild", lua_freyjaGetBoneChild },
	{ "freyjaGetBoneChildCount", lua_freyjaGetBoneChildCount },
	{ "freyjaGetBoneTrackCount", lua_freyjaGetBoneTrackCount },
	{ "freyjaGetBonePosKeyframeTime", lua_freyjaGetBonePosKeyframeTime },
	{ "freyjaBoneKeyframeMetadata", lua_freyjaBoneKeyframeMetadata },
	{ "freyjaGetBoneKeyframeMetadata", lua_freyjaGetBoneKeyframeMetadata },
	{ "freyjaGetBonePosKeyframe3fv", lua_freyjaGetBonePosKeyframe3fv },
	{ "freyjaGetBonePosKeyframeCount", lua_freyjaGetBonePosKeyframeCount },
	{ "freyjaGetBoneRotKeyframeTime", lua_freyjaGetBoneRotKeyframeTime },
	{ "freyjaGetBoneRotKeyframeEuler3fv", lua_freyjaGetBoneRotKeyframeEuler3fv },
	{ "freyjaGetBoneRotKeyframeCount", lua_freyjaGetBoneRotKeyframeCount },
	{ "freyjaBoneUpdateBindPose", lua_freyjaBoneUpdateBindPose },
	{ "freyjaBoneGetBindTransform", lua_freyjaBoneGetBindTransform },
	{ "freyjaBoneGetBindTransformInverse", lua_freyjaBoneGetBindTransformInverse },
	{ "freyjaBoneBindTransformVertex", lua_freyjaBoneBindTransformVertex },
	{ "freyjaBoneTrackNew", lua_freyjaBoneTrackNew },
	{ "freyjaBoneTrackDuration", lua_freyjaBoneTrackDuration },
	{ "freyjaBoneTrackRate", lua_freyjaBoneTrackRate },
	{ "freyjaBoneKeyFrameNew", lua_freyjaBoneKeyFrameNew },
	{ "freyjaBonePosKeyFrame3f", lua_freyjaBonePosKeyFrame3f },
	{ "freyjaBoneRotKeyFrameEuler3f", lua_freyjaBoneRotKeyFrameEuler3f },
	{ "freyjaBoneRotKeyFrameQuat4f", lua_freyjaBoneRotKeyFrameQuat4f },
	{ "freyjaLightCreate", lua_freyjaLightCreate },
	{ "freyjaGetLightCount", lua_freyjaGetLightCount },
	{ "freyjaLightDelete", lua_freyjaLightDelete },
	{ "freyjaLightPosition4v", lua_freyjaLightPosition4v },
	{ "freyjaLightAmbient", lua_freyjaLightAmbient },
	{ "freyjaLightDiffuse", lua_freyjaLightDiffuse },
	{ "freyjaLightSpecular", lua_freyjaLightSpecular },
	{ "freyjaGetLightPosition4v", lua_freyjaGetLightPosition4v },
	{ "freyjaGetLightAmbient", lua_freyjaGetLightAmbient },
	{ "freyjaGetLightDiffuse", lua_freyjaGetLightDiffuse },
	{ "freyjaGetLightSpecular", lua_freyjaGetLightSpecular },
	{ "freyjaMaterialCreate", lua_freyjaMaterialCreate },
	{ "freyjaMaterialClearAll", lua_freyjaMaterialClearAll },
	{ "freyjaGetMaterialCount", lua_freyjaGetMaterialCount },
	{ "freyjaGetMaterialIndex", lua_freyjaGetMaterialIndex },
	{ "freyjaGetMaterialName", lua_freyjaGetMaterialName },
	{ "freyjaGetMaterialFlags", lua_freyjaGetMaterialFlags },
	{ "freyjaGetMaterialShader", lua_freyjaGetMaterialShader },
	{ "freyjaGetMaterialTexture", lua_freyjaGetMaterialTexture },
	{ "freyjaGetMaterialShaderName", lua_freyjaGetMaterialShaderName },
	{ "freyjaGetMaterialTextureName", lua_freyjaGetMaterialTextureName },
	{ "freyjaGetMaterialAmbient", lua_freyjaGetMaterialAmbient },
	{ "freyjaGetMaterialDiffuse", lua_freyjaGetMaterialDiffuse },
	{ "freyjaGetMaterialSpecular", lua_freyjaGetMaterialSpecular },
	{ "freyjaGetMaterialEmissive", lua_freyjaGetMaterialEmissive },
	{ "freyjaGetMaterialShininess", lua_freyjaGetMaterialShininess },
	{ "freyjaGetMaterialTransparency", lua_freyjaGetMaterialTransparency },
	{ "freyjaGetMaterialBlendSource", lua_freyjaGetMaterialBlendSource },
	{ "freyjaGetMaterialBlendDestination", lua_freyjaGetMaterialBlendDestination },
	{ "freyjaMaterialName", lua_freyjaMaterialName },
	{ "freyjaMaterialClearFlag", lua_freyjaMaterialClearFlag },
	{ "freyjaMaterialSetFlag", lua_freyjaMaterialSetFlag },
	{ "freyjaMaterialFlags", lua_freyjaMaterialFlags },
	{ "freyjaMaterialShaderName", lua_freyjaMaterialShaderName },
	{ "freyjaMaterialTextureName", lua_freyjaMaterialTextureName },
	{ "freyjaMaterialShader", lua_freyjaMaterialShader },
	{ "freyjaMaterialTexture", lua_freyjaMaterialTexture },
	{ "freyjaMaterialAmbient", lua_freyjaMaterialAmbient },
	{ "freyjaMaterialDiffuse", lua_freyjaMaterialDiffuse },
	{ "freyjaMaterialSpecular", lua_freyjaMaterialSpecular },
	{ "freyjaMaterialEmissive", lua_freyjaMaterialEmissive },
	{ "freyjaMaterialShininess", lua_freyjaMaterialShininess },
	{ "freyjaMaterialTransparency", lua_freyjaMaterialTransparency },
	{ "freyjaMaterialBlendSource", lua_freyjaMaterialBlendSource },
	{ "freyjaMaterialBlendDestination", lua_freyjaMaterialBlendDestination },
	{ "freyjaPakBegin", lua_freyjaPakBegin },
	{ "freyjaPakAddDecoderFunction2s", lua_freyjaPakAddDecoderFunction2s },
	{ "freyjaPakAddFullPathFile", lua_freyjaPakAddFullPathFile },
	{ "freyjaPakAddFullPathFileXOR", lua_freyjaPakAddFullPathFileXOR },
	{ "freyjaPakEnd", lua_freyjaPakEnd },
	{ "freyjaMeshCreate", lua_freyjaMeshCreate },
	{ "freyjaMeshCopy", lua_freyjaMeshCopy },
	{ "freyjaMeshDelete", lua_freyjaMeshDelete },
	{ "freyjaMeshMaterial", lua_freyjaMeshMaterial },
	{ "freyjaMeshPosition", lua_freyjaMeshPosition },
	{ "freyjaMeshName1s", lua_freyjaMeshName1s },
	{ "freyjaMeshFlags1u", lua_freyjaMeshFlags1u },
	{ "freyjaMeshTransform3fv", lua_freyjaMeshTransform3fv },
	{ "freyjaMeshVertexCreate3fv", lua_freyjaMeshVertexCreate3fv },
	{ "freyjaMeshVertexPos3fv", lua_freyjaMeshVertexPos3fv },
	{ "freyjaMeshVertexNormal3fv", lua_freyjaMeshVertexNormal3fv },
	{ "freyjaMeshTexCoordCreate2fv", lua_freyjaMeshTexCoordCreate2fv },
	{ "freyjaMeshTexCoordCreate2f", lua_freyjaMeshTexCoordCreate2f },
	{ "freyjaMeshTexCoordCreate3fv", lua_freyjaMeshTexCoordCreate3fv },
	{ "freyjaMeshTexCoordCreate3f", lua_freyjaMeshTexCoordCreate3f },
	{ "freyjaMeshTexCoord2fv", lua_freyjaMeshTexCoord2fv },
	{ "freyjaMeshVertexTexCoord3fv", lua_freyjaMeshVertexTexCoord3fv },
	{ "freyjaMeshClampTexCoords", lua_freyjaMeshClampTexCoords },
	{ "freyjaMeshPolygonCreate", lua_freyjaMeshPolygonCreate },
	{ "freyjaMeshPolygonDelete", lua_freyjaMeshPolygonDelete },
	{ "freyjaMeshPolygonAddVertex1i", lua_freyjaMeshPolygonAddVertex1i },
	{ "freyjaMeshPolygonAddTexCoord1i", lua_freyjaMeshPolygonAddTexCoord1i },
	{ "freyjaMeshPolygonMaterial", lua_freyjaMeshPolygonMaterial },
	{ "freyjaMeshPolygonFlipNormal", lua_freyjaMeshPolygonFlipNormal },
	{ "freyjaMeshPolygonComputeNormal", lua_freyjaMeshPolygonComputeNormal },
	{ "freyjaMeshPolygonNormal", lua_freyjaMeshPolygonNormal },
	{ "freyjaMeshPolygonClearFlag1u", lua_freyjaMeshPolygonClearFlag1u },
	{ "freyjaMeshPolygonSetFlag1u", lua_freyjaMeshPolygonSetFlag1u },
	{ "freyjaMeshPolygonGroup1u", lua_freyjaMeshPolygonGroup1u },
	{ "freyjaMeshUVMapPlanar", lua_freyjaMeshUVMapPlanar },
	{ "freyjaMeshUVMapSpherical", lua_freyjaMeshUVMapSpherical },
	{ "freyjaMeshUVMapCylindrical", lua_freyjaMeshUVMapCylindrical },
	{ "freyjaMeshTesselateTriangles", lua_freyjaMeshTesselateTriangles },
	{ "freyjaMeshNormalFlip", lua_freyjaMeshNormalFlip },
	{ "freyjaMeshGenerateVertexNormals", lua_freyjaMeshGenerateVertexNormals },
	{ "freyjaMeshPolygonExtrudeQuad1f", lua_freyjaMeshPolygonExtrudeQuad1f },
	{ "freyjaMeshVertexWeight", lua_freyjaMeshVertexWeight },
	{ "freyjaMeshTexCoordWeld", lua_freyjaMeshTexCoordWeld },
	{ "freyjaMeshVertexWeld", lua_freyjaMeshVertexWeld },
	{ "freyjaMeshUpdateBlendVertices", lua_freyjaMeshUpdateBlendVertices },
	{ "freyjaMeshVertexTrackNew", lua_freyjaMeshVertexTrackNew },
	{ "freyjaMeshVertexKeyFrameNew", lua_freyjaMeshVertexKeyFrameNew },
	{ "freyjaMeshVertexKeyFrame3f", lua_freyjaMeshVertexKeyFrame3f },
	{ "freyjaMeshPolygonSplit", lua_freyjaMeshPolygonSplit },
	{ "freyjaGetMeshCount", lua_freyjaGetMeshCount },
	{ "freyjaGetMeshBoundingBox", lua_freyjaGetMeshBoundingBox },
	{ "freyjaGetMeshBoundingSphere", lua_freyjaGetMeshBoundingSphere },
	{ "freyjaGetMeshFlags", lua_freyjaGetMeshFlags },
	{ "freyjaGetMeshPosition", lua_freyjaGetMeshPosition },
	{ "freyjaGetMeshNameString", lua_freyjaGetMeshNameString },
	{ "freyjaGetMeshVertexFlags", lua_freyjaGetMeshVertexFlags },
	{ "freyjaGetMeshVertexPos3fv", lua_freyjaGetMeshVertexPos3fv },
	{ "freyjaGetMeshVertexNormal3fv", lua_freyjaGetMeshVertexNormal3fv },
	{ "freyjaGetMeshVertexTexCoord3fv", lua_freyjaGetMeshVertexTexCoord3fv },
	{ "freyjaGetMeshVertexTexCoord", lua_freyjaGetMeshVertexTexCoord },
	{ "freyjaGetMeshVertexWeightCount", lua_freyjaGetMeshVertexWeightCount },
	{ "freyjaGetMeshVertexWeightIndex", lua_freyjaGetMeshVertexWeightIndex },
	{ "freyjaGetMeshVertexPolygonRefCount", lua_freyjaGetMeshVertexPolygonRefCount },
	{ "freyjaGetMeshVertexPolygonRefIndex", lua_freyjaGetMeshVertexPolygonRefIndex },
	{ "freyjaGetMeshTexCoord2fv", lua_freyjaGetMeshTexCoord2fv },
	{ "freyjaGetMeshPolygonFlags", lua_freyjaGetMeshPolygonFlags },
	{ "freyjaGetMeshPolygonGroup", lua_freyjaGetMeshPolygonGroup },
	{ "freyjaGetMeshPolygonEdgeCount", lua_freyjaGetMeshPolygonEdgeCount },
	{ "freyjaGetMeshPolygonVertexCount", lua_freyjaGetMeshPolygonVertexCount },
	{ "freyjaGetMeshPolygonVertexIndex", lua_freyjaGetMeshPolygonVertexIndex },
	{ "freyjaGetMeshPolygonTexCoordCount", lua_freyjaGetMeshPolygonTexCoordCount },
	{ "freyjaGetMeshPolygonTexCoordIndex", lua_freyjaGetMeshPolygonTexCoordIndex },
	{ "freyjaGetMeshPolygonMaterial", lua_freyjaGetMeshPolygonMaterial },
	{ "freyjaGetMeshTexCoordCount", lua_freyjaGetMeshTexCoordCount },
	{ "freyjaGetMeshVertexCount", lua_freyjaGetMeshVertexCount },
	{ "freyjaGetMeshNormalCount", lua_freyjaGetMeshNormalCount },
	{ "freyjaGetMeshPolygonCount", lua_freyjaGetMeshPolygonCount },
	{ "freyjaGetMeshBlendVertices", lua_freyjaGetMeshBlendVertices },
	{ "freyjaGetMeshWeightValue", lua_freyjaGetMeshWeightValue },
	{ "freyjaGetMeshWeightBone", lua_freyjaGetMeshWeightBone },
	{ "freyjaGetMeshWeightVertex", lua_freyjaGetMeshWeightVertex },
	{ "freyjaGetMeshWeight", lua_freyjaGetMeshWeight },
	{ "freyjaGetMeshWeightCount", lua_freyjaGetMeshWeightCount },
	{ "freyjaGetMeshVertexTrackCount", lua_freyjaGetMeshVertexTrackCount },
	{ "freyjaGetMeshVertexKeyFrameCount", lua_freyjaGetMeshVertexKeyFrameCount },
	{ "freyjaMeshCreateSheet", lua_freyjaMeshCreateSheet },
	{ "freyjaMeshCreateLattice", lua_freyjaMeshCreateLattice },
	{ "freyjaMeshCreateCube", lua_freyjaMeshCreateCube },
	{ "freyjaMeshCreateRing", lua_freyjaMeshCreateRing },
	{ "freyjaMeshCreateCircle", lua_freyjaMeshCreateCircle },
	{ "freyjaMeshCreateCone", lua_freyjaMeshCreateCone },
	{ "freyjaMeshCreateCylinder", lua_freyjaMeshCreateCylinder },
	{ "freyjaMeshCreateSphere", lua_freyjaMeshCreateSphere },
	{ "freyjaMeshCreateTube", lua_freyjaMeshCreateTube },
	{ NULL, NULL }
};


void Freyja_BindLua()
{
	static bool init = false;
	
	if (init)
		return;

	init = true;
	
	lua_freyja_bind_t *cur;
	unsigned int i = 0;
	
	while ( (cur = &gLibFreyja_LuaBinds[i++]) && cur->symbol )
	{
		gLuaVM.RegisterFunction(cur->symbol, cur->func);
	}
	
	// FIXME: Bind some useful gobals here too.
}


#include "Lua.cpp"
#endif // LUA_FOUND


void freyjaLuaCommand1s(const char *s)
{
#ifdef LUA_FOUND
	Freyja_BindLua();
	
	if (s && s[0])
		gLuaVM.ExecuteCommandSilently(s);
	
#else
	freyjaPrintError("[Module '%s' failed to load.  Rebuild with Lua support.]", s);
#endif // LUA_FOUND
}




void freyjaLuaScript1s(const char *s)
{
#ifdef LUA_FOUND
	Freyja_BindLua();
	
	if (s && s[0])
		gLuaVM.ExecuteFile(s);
	
#else
	freyjaPrintError("[Module '%s' failed to load.  Rebuild with Lua support.]", s);
#endif // LUA_FOUND
}


