/*
 * Prototypes for debugging routines
 */
#if !defined(LIBYAHOO_DEBUG_H)
#define LIBYAHOO_DEBUG_H

#if defined(ENABLE_DEBUG)
int yahoo_dbg_Open(char *file);
int yahoo_dbg_Disable(char *key);
int yahoo_dbg_Enable(char *key);
int yahoo_dbg_Print(char *key, char *format, ...);
int yahoo_dbg_Close(void);
int yahoo_dbg_IsEnabled(char *key);

#else
inline int yahoo_dbg_Open(char *file);
inline int yahoo_dbg_Disable(char *key);
inline int yahoo_dbg_Enable(char *key);
inline int yahoo_dbg_Print(char *key, char *format, ...);
inline int yahoo_dbg_Close(void);
inline int yahoo_dbg_IsEnabled(char *key);

#endif

#define yahoo_dbg_NullCheck(x) ((x)?(x):("[NULL]"))

#endif
