;*
;THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
;SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
;END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
;ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
;IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
;SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
;FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
;CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
;AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
;COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
;*/
;
; $Source: f:/miner/source/fix/rcs/fix.inc $
; $Revision: 1.7 $
; $Author: matt $
; $Date: 1994/01/19 23:12:00 $
;
; Header for fixed-point library
;
; $Log: fix.inc $
; Revision 1.7  1994/01/19  23:12:00  matt
; Made fix_atan2() left-handed, like our coordinate system
; 
; Revision 1.6  1993/10/20  01:08:49  matt
; Add fix_asin(), improved fix_atan2()
; 
; Revision 1.5  1993/10/19  23:53:36  matt
; Added fix_atan2()
; 
; Revision 1.4  1993/10/19  22:32:12  matt
; Added fix_acos()
; 
; Revision 1.3  1993/09/13  12:09:42  matt
; Added extf,extfa macros to generate externdef's of fixed-point types
; 
; Revision 1.2  1993/09/10  11:54:12  matt
; Added missing 'endif' at end of file
; 
; Revision 1.1  1993/08/24  12:59:36  matt
; Initial revision
; 
;
;

	IF (&TYPE('_FIX_INC') = 'UNDEFINED') THEN
_FIX_INC equ 1

	machine	MC68040

;Fixed-point types

fix	RECORD	0
	ds.l	1
	ENDR

fixang	RECORD	0
	ds.w	1
	ENDR

;Externdef macros for fixed-point types

;&	extgen	fix,f	;generates extf
;&	extgen	fixang,fa	;generates extfa

;Some handy constants

f0_0	equ $00000
f1_0	equ $10000
f2_0	equ $20000
f3_0	equ $30000
f10_0	equ $A0000
f0_5	equ $08000
f0_1	equ $0199A

;Macros

;fixed-point multiply. one parm in d0.l, other passed to macro. result in d0.l
;trashes d3.l
	MACRO
&labl	fixmul_	&n
&labl	muls.l	&n,d1:d0
	move.w	d1,d0
	swap	d0
	ENDM

;fixed-point divide. numerator in d0.l, divisor passed to macro. result in d0.l
;trashes d3.l. make sure parameter is not d3.l.
	MACRO
&labl	fixdiv_	&n
&labl:
	tst.l	&n
	beq.s	@zero
	move.l	d0,d1
	swap	d1
	ext.l	d1
	swap	d0
	clr.w	d0
	divs.l	&n,d1:d0
@zero:
	ENDM

;fixed-point multiply and divide. one parm in d0.l, result in d0.l
	MACRO
&labl	fixmuldiv_	&a,&b
&labl:
	tst.l	&b
	beq.s	@zero
	muls.l	&a,d1:d0
	divs.l	&b,d1:d0
@zero:
	ENDM


	IF (&TYPE('_NO_FIX_IMPORTS') = 'UNDEFINED') THEN

;Functions
	import	fix_fastsincos	;takes d0.w=ang, ret (a0)=sin, (a1)=cos
	import	fix_fastsincos_	;takes d0.w=ang, ret d0.l=sin, d1.l=cos
	import	fix_sincos	;takes d0.w=ang, ret (a0)=sin, (a1)=cos
	impor
sincos_	;takes d0.w=ang, ret d0.l=sin, d1.l=cos
	import	fix_asin	;takes d0.l=sin(angle), returns d0.w=angle
	import	fix_acos	;takes d0.l=cos(angle), returns d0.w=angle
	import	fix_atan2	;takes d0.l,d1.l = cos,sin, ret d0.w=angle
	import	long_sqrt	;takes d0.l, returns d0.w
	import	fix_sqrt	;takes d0.l, returns d0.l	
	import	quad_sqrt	;takes d1.l:d0.l, returns d0.l

	ENDIF	;_NO_FIX_IMPORTS


	ENDIF	;_FIX_INC

